/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.engine.domain.execution.engine;

import com.chutneytesting.action.domain.ActionTemplate;
import com.chutneytesting.action.domain.ActionTemplateRegistry;
import com.chutneytesting.action.domain.parameter.ParameterResolver;
import com.chutneytesting.action.spi.Action;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.ActionsConfiguration;
import com.chutneytesting.action.spi.injectable.FinallyActionRegistry;
import com.chutneytesting.action.spi.injectable.Logger;
import com.chutneytesting.action.spi.injectable.StepDefinitionSpi;
import com.chutneytesting.action.spi.injectable.Target;
import com.chutneytesting.engine.domain.execution.ScenarioExecution;
import com.chutneytesting.engine.domain.execution.StepDefinition;
import com.chutneytesting.engine.domain.execution.engine.StepExecutor;
import com.chutneytesting.engine.domain.execution.engine.parameterResolver.ContextParameterResolver;
import com.chutneytesting.engine.domain.execution.engine.parameterResolver.DelegateLogger;
import com.chutneytesting.engine.domain.execution.engine.parameterResolver.InputParameterResolver;
import com.chutneytesting.engine.domain.execution.engine.parameterResolver.TypedValueParameterResolver;
import com.chutneytesting.engine.domain.execution.engine.step.Step;
import com.chutneytesting.engine.domain.execution.engine.step.StepContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.LoggerFactory;

public class DefaultStepExecutor
implements StepExecutor {
    private static final org.slf4j.Logger LOGGER = LoggerFactory.getLogger(DefaultStepExecutor.class);
    private final ActionTemplateRegistry actionTemplateRegistry;

    public DefaultStepExecutor(ActionTemplateRegistry actionTemplateRegistry) {
        this.actionTemplateRegistry = actionTemplateRegistry;
    }

    @Override
    public void execute(ScenarioExecution scenarioExecution, StepContext stepContext, Target targetServer, Step step) {
        block7: {
            String type = step.type();
            Optional<ActionTemplate> matchedAction = this.actionTemplateRegistry.getByIdentifier(type);
            if (matchedAction.isPresent()) {
                List<ParameterResolver> parameterResolvers = this.gatherResolvers(scenarioExecution, stepContext, targetServer, step);
                try {
                    Action action = matchedAction.get().create(parameterResolvers);
                    List errors = action.validateInputs();
                    if (errors.isEmpty()) {
                        ActionExecutionResult executionResult = action.execute();
                        this.updateStepFromActionResult(step, executionResult);
                        this.updateStepContextFromActionResult(stepContext, executionResult);
                        break block7;
                    }
                    step.failure(errors.toArray(new String[0]));
                }
                catch (Exception e) {
                    LOGGER.error("Cannot execute step: ", (Throwable)e);
                    step.failure("Action [" + type + "] failed: " + Optional.ofNullable(e.getMessage()).orElse(e.toString()));
                }
            } else if (type.isEmpty()) {
                step.success(new String[0]);
            } else {
                step.failure("Action [" + type + "] not found");
            }
        }
    }

    private void updateStepContextFromActionResult(StepContext stepContext, ActionExecutionResult executionResult) {
        if (executionResult.status == ActionExecutionResult.Status.Success) {
            stepContext.addStepOutputs(executionResult.outputs);
            stepContext.getScenarioContext().putAll(executionResult.outputs);
        }
    }

    private void updateStepFromActionResult(Step step, ActionExecutionResult executionResult) {
        if (executionResult.status == ActionExecutionResult.Status.Success) {
            step.success(new String[0]);
        } else {
            step.failure(new String[0]);
        }
    }

    private List<ParameterResolver> gatherResolvers(ScenarioExecution scenarioExecution, StepContext stepContext, Target target, Step step) {
        ArrayList<ParameterResolver> parameterResolvers = new ArrayList<ParameterResolver>();
        parameterResolvers.add(new InputParameterResolver(stepContext.getEvaluatedInputs()));
        parameterResolvers.add(new TypedValueParameterResolver<Target>(Target.class, target));
        parameterResolvers.add(new TypedValueParameterResolver<DelegateLogger>(Logger.class, new DelegateLogger(xva$0 -> step.addInformation((String)xva$0), xva$0 -> step.failure((String)xva$0))));
        parameterResolvers.add(new TypedValueParameterResolver<StepDefinition>(StepDefinitionSpi.class, step.definition()));
        parameterResolvers.add(new TypedValueParameterResolver<FinallyActionRegistry>(FinallyActionRegistry.class, scenarioExecution::registerFinallyAction));
        parameterResolvers.add(new TypedValueParameterResolver<ActionsConfiguration>(ActionsConfiguration.class, scenarioExecution.getActionsConfiguration()));
        parameterResolvers.add(new ContextParameterResolver(stepContext.getScenarioContext()));
        return parameterResolvers;
    }
}

