/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.domain;

import com.chutneytesting.task.domain.TaskTemplate;
import com.chutneytesting.task.domain.TaskTemplateLoaders;
import com.chutneytesting.task.domain.TaskTemplateRegistry;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTaskTemplateRegistry
implements TaskTemplateRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTaskTemplateRegistry.class);
    private final TaskTemplateLoaders loaders;
    private final Map<String, TaskTemplate> taskTemplatesByType = new ConcurrentHashMap<String, TaskTemplate>();

    public DefaultTaskTemplateRegistry(TaskTemplateLoaders taskTemplateLoader) {
        this.loaders = taskTemplateLoader;
        this.refresh();
    }

    @Override
    public synchronized void refresh() {
        this.taskTemplatesByType.clear();
        this.loaders.orderedTemplates().forEach(taskTemplate -> {
            TaskTemplate alreadyStoredTaskTemplate = this.taskTemplatesByType.putIfAbsent(taskTemplate.identifier(), (TaskTemplate)taskTemplate);
            if (alreadyStoredTaskTemplate != null) {
                LOGGER.warn("Unable to register TaskTemplate[" + taskTemplate.identifier() + " (" + taskTemplate.implementationClass().getName() + ")]: already defined by " + alreadyStoredTaskTemplate.implementationClass().getName());
            } else {
                LOGGER.debug("Task registered: " + taskTemplate.identifier() + " (" + taskTemplate.implementationClass().getName() + ")");
            }
        });
    }

    @Override
    public Optional<TaskTemplate> getByIdentifier(String identifier) {
        return Optional.ofNullable(this.taskTemplatesByType.get(identifier));
    }

    @Override
    public Collection<TaskTemplate> getAll() {
        return this.taskTemplatesByType.values();
    }
}

