/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.engine.domain.execution.engine.parameterResolver;

import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegateLogger
implements com.chutneytesting.task.spi.injectable.Logger {
    private final Consumer<String> infoConsumer;
    private final Consumer<String> errorConsumer;
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegateLogger.class);

    public DelegateLogger(Consumer<String> infoConsumer, Consumer<String> errorConsumer) {
        this.infoConsumer = infoConsumer;
        this.errorConsumer = errorConsumer;
    }

    public void info(String message) {
        this.infoConsumer.accept(message);
        LOGGER.debug(message);
    }

    public void error(String message) {
        this.errorConsumer.accept(message);
        LOGGER.debug(message);
    }

    public void error(Throwable exception) {
        this.errorConsumer.accept(exception.getMessage());
        LOGGER.debug(exception.getMessage(), exception);
    }
}

