/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting;

import com.chutneytesting.EngineTasksConfiguration;
import com.chutneytesting.engine.api.execution.EmbeddedTestEngine;
import com.chutneytesting.engine.api.execution.TestEngine;
import com.chutneytesting.engine.domain.delegation.DelegationService;
import com.chutneytesting.engine.domain.execution.ExecutionEngine;
import com.chutneytesting.engine.domain.execution.ExecutionManager;
import com.chutneytesting.engine.domain.execution.engine.DefaultExecutionEngine;
import com.chutneytesting.engine.domain.execution.engine.DefaultStepExecutor;
import com.chutneytesting.engine.domain.execution.engine.evaluation.StepDataEvaluator;
import com.chutneytesting.engine.domain.execution.evaluation.SpelFunctionCallback;
import com.chutneytesting.engine.domain.execution.evaluation.SpelFunctions;
import com.chutneytesting.engine.domain.execution.strategies.StepExecutionStrategies;
import com.chutneytesting.engine.domain.execution.strategies.StepExecutionStrategy;
import com.chutneytesting.engine.domain.report.Reporter;
import com.chutneytesting.engine.infrastructure.delegation.HttpClient;
import com.chutneytesting.task.domain.DefaultTaskTemplateRegistry;
import com.chutneytesting.task.domain.TaskTemplateLoader;
import com.chutneytesting.task.domain.TaskTemplateLoaders;
import com.chutneytesting.task.domain.TaskTemplateParserV2;
import com.chutneytesting.task.domain.TaskTemplateRegistry;
import com.chutneytesting.task.infra.DefaultTaskTemplateLoader;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.injectable.TasksConfiguration;
import com.chutneytesting.tools.Streams;
import com.chutneytesting.tools.ThrowingFunction;
import com.chutneytesting.tools.loader.ExtensionLoaders;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class ExecutionConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionConfiguration.class);
    private final TaskTemplateRegistry taskTemplateRegistry;
    private final Reporter reporter;
    private final ExecutionEngine executionEngine;
    private final TestEngine embeddedTestEngine;
    private final SpelFunctions spelFunctions;
    private final Set<StepExecutionStrategy> stepExecutionStrategies;
    private final Long reporterTTL;

    public ExecutionConfiguration() {
        this(5L, Executors.newFixedThreadPool(10), Collections.emptyMap(), null, null);
    }

    public ExecutionConfiguration(Long reporterTTL, Executor taskExecutor, Map<String, String> tasksConfiguration, String user, String password) {
        this.reporterTTL = reporterTTL;
        TaskTemplateLoader taskTemplateLoaderV2 = this.createTaskTemplateLoaderV2();
        this.spelFunctions = this.createSpelFunctions();
        this.stepExecutionStrategies = this.createStepExecutionStrategies();
        this.taskTemplateRegistry = new DefaultTaskTemplateRegistry(new TaskTemplateLoaders(Collections.singletonList(taskTemplateLoaderV2)));
        this.reporter = this.createReporter();
        this.executionEngine = this.createExecutionEngine(taskExecutor, user, password);
        this.embeddedTestEngine = this.createEmbeddedTestEngine(new EngineTasksConfiguration(tasksConfiguration));
    }

    public TaskTemplateRegistry taskTemplateRegistry() {
        return this.taskTemplateRegistry;
    }

    public TestEngine embeddedTestEngine() {
        return this.embeddedTestEngine;
    }

    public Set<StepExecutionStrategy> stepExecutionStrategies() {
        return this.stepExecutionStrategies;
    }

    public Reporter reporter() {
        return this.reporter;
    }

    public ExecutionEngine executionEngine() {
        return this.executionEngine;
    }

    private TaskTemplateLoader createTaskTemplateLoaderV2() {
        return new DefaultTaskTemplateLoader<Task>("chutney.tasks", Task.class, new TaskTemplateParserV2());
    }

    private SpelFunctions createSpelFunctions() {
        SpelFunctionCallback spelFunctionCallback = new SpelFunctionCallback();
        ExtensionLoaders.classpathToClass((String)"META-INF/extension/chutney.functions").load().forEach(c -> ReflectionUtils.doWithMethods((Class)c, (ReflectionUtils.MethodCallback)spelFunctionCallback));
        return spelFunctionCallback.getSpelFunctions();
    }

    private Set<StepExecutionStrategy> createStepExecutionStrategies() {
        return ExtensionLoaders.classpathToClass((String)"META-INF/extension/chutney.strategies").load().stream().map(ThrowingFunction.toUnchecked(ExecutionConfiguration::instantiate)).map(Streams.identity(c -> LOGGER.debug("Loading strategy: " + c.getType() + " (" + c.getClass().getSimpleName() + ")"))).collect(Collectors.toSet());
    }

    private Reporter createReporter() {
        return new Reporter(this.reporterTTL);
    }

    private ExecutionEngine createExecutionEngine(Executor taskExecutor, String user, String password) {
        return new DefaultExecutionEngine(new StepDataEvaluator(this.spelFunctions), new StepExecutionStrategies(this.stepExecutionStrategies), new DelegationService(new DefaultStepExecutor(this.taskTemplateRegistry), new HttpClient(user, password)), this.reporter, taskExecutor);
    }

    private TestEngine createEmbeddedTestEngine(TasksConfiguration tasksConfiguration) {
        return new EmbeddedTestEngine(this.executionEngine, this.reporter, new ExecutionManager(), tasksConfiguration);
    }

    private static <T> T instantiate(Class<?> clazz) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        return (T)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }
}

