/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.component.scenario.api.dto;

import com.chutneytesting.component.scenario.api.dto.ComposableStepDto;
import com.chutneytesting.component.scenario.api.dto.ImmutableComposableScenarioDto;
import com.chutneytesting.component.scenario.api.dto.ImmutableComposableTestCaseDto;
import com.chutneytesting.server.core.domain.security.User;
import com.chutneytesting.server.core.domain.tools.ui.KeyValue;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableComposableTestCaseDto.class)
@JsonDeserialize(as=ImmutableComposableTestCaseDto.class)
@JsonIgnoreProperties(ignoreUnknown=true)
@Value.Immutable
@Value.Style(jdkOnly=true)
public interface ComposableTestCaseDto {
    public Optional<String> id();

    public String title();

    public Optional<String> description();

    @Value.Default
    default public Instant creationDate() {
        return Instant.now();
    }

    public List<String> tags();

    public ComposableScenarioDto scenario();

    public Optional<String> datasetId();

    @Value.Default
    default public String author() {
        return User.ANONYMOUS.id;
    }

    @Value.Default
    default public Instant updateDate() {
        return Instant.now();
    }

    @Value.Default
    default public Integer version() {
        return 1;
    }

    @JsonProperty(value="computedParameters")
    @Value.Default
    default public List<KeyValue> executionParameters() {
        return Collections.emptyList();
    }

    @JsonSerialize(as=ImmutableComposableScenarioDto.class)
    @JsonDeserialize(as=ImmutableComposableScenarioDto.class)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @Value.Immutable
    @Value.Style(jdkOnly=true)
    public static interface ComposableScenarioDto {
        @Value.Default
        default public List<KeyValue> parameters() {
            return Collections.emptyList();
        }

        @Value.Default
        default public List<ComposableStepDto> componentSteps() {
            return Collections.emptyList();
        }
    }
}

