/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.component.scenario.api;

import com.chutneytesting.component.execution.domain.ExecutableComposedTestCase;
import com.chutneytesting.component.scenario.api.ComposableTestCaseMapper;
import com.chutneytesting.component.scenario.api.ExecutableComposableTestCaseMapper;
import com.chutneytesting.component.scenario.api.dto.ComposableTestCaseDto;
import com.chutneytesting.component.scenario.domain.ComposableTestCase;
import com.chutneytesting.component.scenario.infra.OrientComposableTestCaseRepository;
import com.chutneytesting.server.core.domain.execution.ExecutionRequest;
import com.chutneytesting.server.core.domain.execution.processor.TestCasePreProcessors;
import com.chutneytesting.server.core.domain.scenario.ScenarioNotFoundException;
import com.chutneytesting.server.core.domain.scenario.TestCase;
import com.chutneytesting.server.core.domain.scenario.TestCaseMetadata;
import com.chutneytesting.server.core.domain.scenario.TestCaseMetadataImpl;
import com.chutneytesting.server.core.domain.security.UserService;
import com.chutneytesting.server.core.domain.tools.ui.KeyValue;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@RequestMapping(value={"/api/scenario/component-edition"})
public class ComponentEditionController {
    static final String BASE_URL = "/api/scenario/component-edition";
    private final OrientComposableTestCaseRepository composableTestCaseRepository;
    private final UserService userService;
    private final TestCasePreProcessors testCasePreProcessors;

    public ComponentEditionController(OrientComposableTestCaseRepository orientComposableTestCaseRepository, UserService userService, TestCasePreProcessors testCasePreProcessors) {
        this.composableTestCaseRepository = orientComposableTestCaseRepository;
        this.userService = userService;
        this.testCasePreProcessors = testCasePreProcessors;
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_WRITE')")
    @PostMapping(path={""}, consumes={"application/json"}, produces={"application/json"})
    public String saveTestCase(@RequestBody ComposableTestCaseDto composableTestCaseDto) {
        ComposableTestCase composableTestCase = ComposableTestCaseMapper.fromDto(composableTestCaseDto);
        composableTestCase = new ComposableTestCase(composableTestCase.id, (TestCaseMetadata)TestCaseMetadataImpl.TestCaseMetadataBuilder.from((TestCaseMetadata)composableTestCase.metadata).withUpdateDate(Instant.now()).withAuthor(this.userService.currentUserId()).build(), composableTestCase.composableScenario);
        return this.composableTestCaseRepository.save(composableTestCase);
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_READ')")
    @GetMapping(path={"/{testCaseId}"}, produces={"application/json"})
    public ComposableTestCaseDto getTestCase(@PathVariable(value="testCaseId") String testCaseId) {
        ComposableTestCase composableTestCase = this.composableTestCaseRepository.findById(testCaseId).orElseThrow(() -> new ScenarioNotFoundException(testCaseId));
        return ComposableTestCaseMapper.toDto(composableTestCase);
    }

    @PreAuthorize(value="hasAuthority('CAMPAIGN_WRITE')")
    @GetMapping(path={"/{testCaseId}/executable/parameters"}, produces={"application/json"})
    public List<KeyValue> getTestCaseExecutionParameters(@PathVariable(value="testCaseId") String testCaseId) {
        return ComposableTestCaseMapper.toDto(this.composableTestCaseRepository.findById(testCaseId).orElseThrow(() -> new ScenarioNotFoundException(testCaseId))).executionParameters();
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_READ')")
    @GetMapping(path={"/{testCaseId}/executable"}, produces={"application/json"})
    public ComposableTestCaseDto getExecutableTestCase(@PathVariable(value="testCaseId") String testCaseId) {
        Optional<TestCase> testCase = this.composableTestCaseRepository.findExecutableById(testCaseId);
        if (testCase.isPresent()) {
            ExecutableComposedTestCase result = (ExecutableComposedTestCase)this.testCasePreProcessors.apply(new ExecutionRequest(testCase.get(), "env", "userId"));
            return ExecutableComposableTestCaseMapper.toDto(result);
        }
        throw new ScenarioNotFoundException(testCaseId);
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_WRITE')")
    @DeleteMapping(path={"/{testCaseId}"})
    public void removeScenarioById(@PathVariable(value="testCaseId") String testCaseId) {
        this.composableTestCaseRepository.removeById(testCaseId);
    }
}

