/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.component.execution.domain;

import com.chutneytesting.component.execution.domain.ExecutableComposedScenario;
import com.chutneytesting.server.core.domain.scenario.TestCase;
import com.chutneytesting.server.core.domain.scenario.TestCaseMetadata;
import com.chutneytesting.server.core.domain.scenario.TestCaseMetadataImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ExecutableComposedTestCase
implements TestCase {
    public final TestCaseMetadata metadata;
    public final ExecutableComposedScenario composedScenario;
    public final Map<String, String> executionParameters;

    public ExecutableComposedTestCase(TestCaseMetadata metadata, ExecutableComposedScenario composedScenario) {
        this.metadata = metadata;
        this.composedScenario = composedScenario;
        this.executionParameters = this.buildDataSet();
    }

    public ExecutableComposedTestCase(TestCaseMetadata metadata, ExecutableComposedScenario composedScenario, Map<String, String> executionParameters) {
        this.metadata = metadata;
        this.composedScenario = composedScenario;
        this.executionParameters = executionParameters;
    }

    public TestCaseMetadata metadata() {
        return this.metadata;
    }

    public Map<String, String> executionParameters() {
        return this.executionParameters;
    }

    public TestCase usingExecutionParameters(Map<String, String> parameters) {
        return new ExecutableComposedTestCase(this.metadata, this.composedScenario, parameters);
    }

    public TestCase withDataSetId(String dataSetId) {
        return new ExecutableComposedTestCase((TestCaseMetadata)TestCaseMetadataImpl.TestCaseMetadataBuilder.from((TestCaseMetadata)this.metadata).withDefaultDataset(dataSetId).build(), this.composedScenario, this.executionParameters);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutableComposedTestCase that = (ExecutableComposedTestCase)o;
        return Objects.equals(this.metadata, that.metadata) && Objects.equals(this.composedScenario, that.composedScenario) && Objects.equals(this.executionParameters, that.executionParameters);
    }

    public int hashCode() {
        return Objects.hash(this.metadata, this.composedScenario, this.executionParameters);
    }

    private Map<String, String> buildDataSet() {
        HashMap<String, String> dataSet = new HashMap<String, String>();
        this.composedScenario.composedSteps.forEach(composedStep -> dataSet.putAll(composedStep.getEmptyExecutionParameters()));
        Optional.ofNullable(this.composedScenario.parameters).ifPresent(dataSet::putAll);
        return dataSet;
    }

    public String toString() {
        return "ExecutableComposedTestCase{, metadata=" + this.metadata + ", ExecutableComposedScenario=" + this.composedScenario + ", dataSet=" + this.executionParameters + "}";
    }
}

