/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.component.dataset.infra;

import com.chutneytesting.component.dataset.infra.DataSetPatch;
import com.chutneytesting.server.core.domain.dataset.DataSet;
import com.github.difflib.DiffUtils;
import com.github.difflib.UnifiedDiffUtils;
import com.github.difflib.algorithm.DiffException;
import com.github.difflib.patch.Patch;
import com.github.difflib.patch.PatchFailedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;

public final class DataSetPatchUtils {
    private static final String SPACE = " ";
    private static final String SEPARATOR = "|";
    private static final String NEWLINE = "\n";
    private static final String SEPARATOR_SPACED = " | ";
    private static final String SEPARATOR_REGEX = "\\|";

    private DataSetPatchUtils() {
    }

    public static Pair<Map<String, String>, List<Map<String, String>>> extractValues(String s) {
        LinkedHashMap<String, String> constants = new LinkedHashMap<String, String>();
        ArrayList datatable = new ArrayList();
        ArrayList<String> datatableHeaders = new ArrayList<String>();
        List<String> lines = DataSetPatchUtils.stringLines(s);
        for (String line : lines) {
            if ((line = line.trim()).isEmpty()) continue;
            if (line.startsWith(SEPARATOR)) {
                List<String> lineValues = DataSetPatchUtils.extractDatatableLine(line);
                if (datatableHeaders.isEmpty()) {
                    datatableHeaders.addAll(lineValues);
                    continue;
                }
                LinkedHashMap<String, String> valuesMap = new LinkedHashMap<String, String>();
                Iterator headersIterator = datatableHeaders.iterator();
                Iterator<String> valuesIterator = lineValues.iterator();
                while (headersIterator.hasNext() && valuesIterator.hasNext()) {
                    valuesMap.put((String)headersIterator.next(), valuesIterator.next());
                }
                datatable.add(valuesMap);
                continue;
            }
            String[] constant = line.split(SEPARATOR_REGEX);
            if (constant.length == 2) {
                constants.put(constant[0].trim(), constant[1].trim());
                continue;
            }
            if (constant.length != 1) continue;
            constants.put(constant[0].trim(), "");
        }
        return Pair.of(constants, datatable);
    }

    public static String dataSetValues(DataSet dataSet, boolean pretty) {
        Map constants = dataSet.constants;
        List datatable = dataSet.datatable;
        StringBuilder values = new StringBuilder();
        if (!constants.isEmpty()) {
            int maxKeyLength = 0;
            if (pretty) {
                maxKeyLength = constants.keySet().stream().mapToInt(String::length).max().getAsInt();
            }
            int finalMaxKeyLength = maxKeyLength;
            constants.forEach((k, v) -> DataSetPatchUtils.addConstantLine(values, k, v, finalMaxKeyLength - k.length()));
            values.append(NEWLINE);
        }
        if (!datatable.isEmpty()) {
            ArrayList<String> headers = new ArrayList<String>(((Map)datatable.get(0)).keySet());
            ArrayList<Integer> columnLength = new ArrayList<Integer>();
            if (pretty) {
                headers.forEach(m -> columnLength.add(datatable.stream().mapToInt(mm -> ((String)mm.get(m)).length()).max().getAsInt()));
            }
            DataSetPatchUtils.addDatatableLine(values, headers, columnLength, Collections.emptyMap());
            datatable.forEach(m -> DataSetPatchUtils.addDatatableLine(values, headers, columnLength, m));
        }
        return values.toString();
    }

    public static String unifiedDiff(String revised, String original) {
        try {
            List<String> originalLines = DataSetPatchUtils.stringLines(original);
            Patch diff = DiffUtils.diff(originalLines, DataSetPatchUtils.stringLines(revised));
            List unifiedDiff = UnifiedDiffUtils.generateUnifiedDiff((String)"original", (String)"revised", originalLines, (Patch)diff, (int)0);
            return String.join((CharSequence)"\r", unifiedDiff);
        }
        catch (DiffException e) {
            throw new RuntimeException(e);
        }
    }

    public static String patchString(String original, DataSetPatch dataSetPatch) throws PatchFailedException {
        Optional<String> unifiedDiffValues = Optional.ofNullable(dataSetPatch.unifiedDiffValues);
        if (unifiedDiffValues.isPresent()) {
            List<String> originalLines = DataSetPatchUtils.stringLines(original);
            List<String> diffLines = DataSetPatchUtils.stringLines(unifiedDiffValues.get());
            if (diffLines.size() > 0 && diffLines.size() != 1 && !"".equals(diffLines.get(0))) {
                ArrayList<String> diff = new ArrayList<String>(diffLines);
                Patch patch = UnifiedDiffUtils.parseUnifiedDiff(diff);
                List patchedOriginal = DiffUtils.patch(originalLines, (Patch)patch);
                StringBuilder sb = new StringBuilder();
                patchedOriginal.forEach(s -> sb.append((String)s).append(NEWLINE));
                return sb.toString();
            }
        }
        return original;
    }

    public static List<String> stringLines(String s) {
        return Arrays.asList(s.split("\\R"));
    }

    private static List<String> extractDatatableLine(String line) {
        ArrayList<String> values = new ArrayList<String>();
        String[] lineValues = line.split(SEPARATOR_REGEX);
        for (int i = 1; i < lineValues.length; ++i) {
            values.add(lineValues[i].trim());
        }
        return values;
    }

    private static void addConstantLine(StringBuilder constants, String key, String value, Integer spaces) {
        StringBuilder line = new StringBuilder();
        line.append(key);
        DataSetPatchUtils.addSpaces(line, spaces);
        line.append(SEPARATOR_SPACED).append(value);
        constants.append(line.toString().trim()).append(NEWLINE);
    }

    private static void addDatatableLine(StringBuilder datatable, List<String> headers, List<Integer> columnLength, Map<String, String> values) {
        boolean isLengthSet;
        StringBuilder line = new StringBuilder();
        boolean bl = isLengthSet = !columnLength.isEmpty();
        if (values.isEmpty()) {
            for (int i = 0; i < headers.size(); ++i) {
                String header = headers.get(i);
                line.append(SEPARATOR_SPACED).append(header);
                if (!isLengthSet) continue;
                DataSetPatchUtils.addSpaces(line, columnLength.get(i) - header.length());
            }
        } else {
            for (int i = 0; i < headers.size(); ++i) {
                String value = values.get(headers.get(i));
                line.append(SEPARATOR_SPACED).append(value);
                if (!isLengthSet) continue;
                DataSetPatchUtils.addSpaces(line, columnLength.get(i) - value.length());
            }
        }
        line.append(SEPARATOR_SPACED);
        datatable.append(line.toString().trim()).append(NEWLINE);
    }

    private static void addSpaces(StringBuilder line, Integer nb) {
        line.append(SPACE.repeat(Math.max(0, nb)));
    }
}

