/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.component.execution.domain;

import com.chutneytesting.component.execution.domain.StepImplementation;
import com.chutneytesting.scenario.domain.gwt.Strategy;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ExecutableComposedStep {
    public final String name;
    public final List<ExecutableComposedStep> steps;
    public final Map<String, String> defaultParameters;
    public final Optional<StepImplementation> stepImplementation;
    public final Strategy strategy;
    public final Map<String, String> executionParameters;

    private ExecutableComposedStep(String name, List<ExecutableComposedStep> steps, Map<String, String> defaultParameters, Optional<StepImplementation> implementation, Strategy strategy, Map<String, String> executionParameters) {
        this.name = name;
        this.steps = steps;
        this.defaultParameters = defaultParameters;
        this.stepImplementation = implementation;
        this.strategy = strategy;
        this.executionParameters = executionParameters;
    }

    public Map<String, String> getEmptyExecutionParameters() {
        return this.executionParameters.entrySet().stream().filter(e -> StringUtils.isBlank((CharSequence)((CharSequence)e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static ExecutableComposedStepBuilder builder() {
        return new ExecutableComposedStepBuilder();
    }

    public String toString() {
        return "ExecutableComposedStep{, name='" + this.name + "', steps=" + this.steps + ", parameters=" + this.defaultParameters + ", implementation=" + this.stepImplementation + ", strategy=" + this.strategy.toString() + ", dataSet=" + this.executionParameters + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutableComposedStep that = (ExecutableComposedStep)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.steps, that.steps) && Objects.equals(this.defaultParameters, that.defaultParameters) && Objects.equals(this.stepImplementation, that.stepImplementation) && Objects.equals(this.strategy, that.strategy) && Objects.equals(this.executionParameters, that.executionParameters);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.steps, this.defaultParameters, this.stepImplementation, this.strategy, this.executionParameters);
    }

    public static class ExecutableComposedStepBuilder {
        private String name;
        private List<ExecutableComposedStep> steps = Collections.emptyList();
        private Map<String, String> parameters = Collections.emptyMap();
        private Optional<StepImplementation> implementation;
        private Strategy strategy;
        private Map<String, String> executionParameters = Collections.emptyMap();

        private ExecutableComposedStepBuilder() {
        }

        public ExecutableComposedStep build() {
            return new ExecutableComposedStep(Optional.ofNullable(this.name).orElse(""), Optional.ofNullable(this.steps).orElse(Collections.emptyList()), Optional.ofNullable(this.parameters).orElse(Collections.emptyMap()), Optional.ofNullable(this.implementation).orElse(Optional.empty()), Optional.ofNullable(this.strategy).orElse(Strategy.DEFAULT), Collections.unmodifiableMap(this.buildExecutionParameters()));
        }

        private Map<String, String> buildExecutionParameters() {
            if (this.executionParameters.isEmpty()) {
                HashMap result = Maps.newHashMap();
                this.steps.stream().map(ExecutableComposedStep::getEmptyExecutionParameters).filter(m -> !m.isEmpty()).forEach(m -> result.putAll(m));
                return result;
            }
            return this.executionParameters;
        }

        public ExecutableComposedStepBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public ExecutableComposedStepBuilder withSteps(List<ExecutableComposedStep> steps) {
            this.steps = Collections.unmodifiableList(steps);
            return this;
        }

        public ExecutableComposedStepBuilder withParameters(Map<String, String> parameters) {
            this.parameters = Collections.unmodifiableMap(parameters);
            return this;
        }

        public ExecutableComposedStepBuilder withExecutionParameters(Map<String, String> executionParameters) {
            this.executionParameters = Optional.ofNullable(executionParameters).orElse(Collections.emptyMap());
            return this;
        }

        public ExecutableComposedStepBuilder withImplementation(Optional<StepImplementation> implementation) {
            this.implementation = implementation;
            return this;
        }

        public ExecutableComposedStepBuilder withStrategy(Strategy strategy) {
            this.strategy = strategy;
            return this;
        }

        public ExecutableComposedStepBuilder addParameters(Map<String, String> parameters) {
            Optional.ofNullable(parameters).ifPresent(this.parameters::putAll);
            return this;
        }

        public final ExecutableComposedStepBuilder from(ExecutableComposedStep instance) {
            this.name = instance.name;
            this.steps = instance.steps;
            this.parameters = instance.defaultParameters;
            this.implementation = instance.stepImplementation;
            this.strategy = instance.strategy;
            this.executionParameters = new LinkedHashMap<String, String>(instance.executionParameters);
            return this;
        }
    }
}

