/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.component.execution.domain;

import com.chutneytesting.component.dataset.infra.OrientDataSetRepository;
import com.chutneytesting.component.execution.domain.ExecutableComposedScenario;
import com.chutneytesting.component.execution.domain.ExecutableComposedStep;
import com.chutneytesting.component.execution.domain.ExecutableComposedTestCase;
import com.chutneytesting.component.execution.domain.StepImplementation;
import com.chutneytesting.scenario.domain.gwt.Strategy;
import com.chutneytesting.server.core.domain.dataset.DataSet;
import com.chutneytesting.server.core.domain.dataset.DataSetNotFoundException;
import com.chutneytesting.server.core.domain.execution.ExecutionRequest;
import com.chutneytesting.server.core.domain.execution.processor.TestCasePreProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;

public class ComposedTestCaseDatatableIterationsPreProcessor
implements TestCasePreProcessor<ExecutableComposedTestCase> {
    public static final String DATASET_ITERATIONS_STRATEGY_TYPE = "dataset-iterations-strategy";
    private final OrientDataSetRepository dataSetRepository;
    final Pattern aliasPattern = Pattern.compile("^\\*\\*(.+)\\*\\*$");

    ComposedTestCaseDatatableIterationsPreProcessor(OrientDataSetRepository dataSetRepository) {
        this.dataSetRepository = dataSetRepository;
    }

    public ExecutableComposedTestCase apply(ExecutionRequest executionRequest) {
        ExecutableComposedTestCase testCase = (ExecutableComposedTestCase)executionRequest.testCase;
        return this.apply(testCase);
    }

    ExecutableComposedTestCase apply(ExecutableComposedTestCase testCase) {
        if (testCase.metadata.defaultDataset().isBlank()) {
            return testCase;
        }
        try {
            DataSet dataset = this.dataSetRepository.findById(testCase.metadata.defaultDataset());
            Map<Boolean, List<String>> matchedHeaders = this.findDatableHeadersMatchingExecutionParameters(testCase, dataset.datatable);
            return new ExecutableComposedTestCase(testCase.metadata, this.applyToScenario(testCase.composedScenario, matchedHeaders, dataset), this.applyToExecutionParameters(testCase.executionParameters, matchedHeaders.get(Boolean.TRUE), dataset));
        }
        catch (DataSetNotFoundException e) {
            return testCase;
        }
    }

    private Map<Boolean, List<String>> findDatableHeadersMatchingExecutionParameters(ExecutableComposedTestCase testCase, List<Map<String, String>> datatable) {
        Map<Boolean, List<String>> matchedHeaders = new HashMap<Boolean, List<String>>();
        if (!datatable.isEmpty()) {
            Set<String> headers = datatable.get(0).keySet();
            matchedHeaders = testCase.executionParameters.keySet().stream().collect(Collectors.groupingBy(headers::contains));
        }
        matchedHeaders.putIfAbsent(Boolean.TRUE, Collections.emptyList());
        matchedHeaders.putIfAbsent(Boolean.FALSE, Collections.emptyList());
        return matchedHeaders;
    }

    private Map<String, String> applyToExecutionParameters(Map<String, String> executionParameters, List<String> matchedHeaders, DataSet dataset) {
        HashMap<String, String> parameters = new HashMap<String, String>(executionParameters);
        Map constants = dataset.constants;
        executionParameters.keySet().stream().filter(constants::containsKey).forEach(key -> parameters.put((String)key, (String)constants.get(key)));
        executionParameters.keySet().stream().filter(matchedHeaders::contains).forEach(parameters::remove);
        return parameters;
    }

    private ExecutableComposedScenario applyToScenario(ExecutableComposedScenario composedScenario, Map<Boolean, List<String>> matchedHeaders, DataSet dataset) {
        HashMap iterationOutputs = new HashMap();
        return ExecutableComposedScenario.builder().withComposedSteps(composedScenario.composedSteps.stream().map(cs -> this.applyToStep((ExecutableComposedStep)cs, matchedHeaders, dataset, iterationOutputs)).collect(Collectors.toList())).withParameters(composedScenario.parameters).build();
    }

    private ExecutableComposedStep applyToStep(ExecutableComposedStep composedStep, Map<Boolean, List<String>> matchedHeaders, DataSet dataset, Map<String, Integer> iterationOutputs) {
        Set<String> executionParametersReferencingDatableHeadersInKey = this.findHeadersReferencesWithinEmptyParametersKey(composedStep.executionParameters, matchedHeaders.get(Boolean.TRUE));
        Map<String, Set<String>> executionParametersReferencingDatableHeadersInValue = this.findHeadersReferencesWithinParameterValues(composedStep.executionParameters, matchedHeaders.get(Boolean.TRUE));
        Map<String, Integer> usedIndexedOutput = this.findUsageOfPreviousOutputInImplementation(composedStep, iterationOutputs);
        Map<String, Integer> usedIndexedOutputInDataset = this.findUsageOfPreviousOutputInExecutionParameters(composedStep, iterationOutputs);
        if (executionParametersReferencingDatableHeadersInKey.isEmpty() && executionParametersReferencingDatableHeadersInValue.isEmpty() && usedIndexedOutput.isEmpty() && usedIndexedOutputInDataset.isEmpty()) {
            this.removeObsoleteIndexedOutputs(iterationOutputs, composedStep);
            return composedStep;
        }
        Map<String, String> emptyExecutionParameters = composedStep.executionParameters.entrySet().stream().filter(e -> ((String)e.getValue()).isEmpty()).filter(e -> !executionParametersReferencingDatableHeadersInKey.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        matchedHeaders.get(Boolean.FALSE).forEach(s -> emptyExecutionParameters.put((String)s, ""));
        return ExecutableComposedStep.builder().from(composedStep).withImplementation(Optional.empty()).withStrategy(new Strategy(DATASET_ITERATIONS_STRATEGY_TYPE, Collections.emptyMap())).withSteps(this.buildStepIterations(composedStep, dataset.datatable, executionParametersReferencingDatableHeadersInKey, executionParametersReferencingDatableHeadersInValue, iterationOutputs)).withExecutionParameters(this.buildExecutionParametersWithAliases(emptyExecutionParameters)).build();
    }

    private Map<String, Integer> findUsageOfPreviousOutputInExecutionParameters(ExecutableComposedStep composedStep, Map<String, Integer> iterationOutputs) {
        return iterationOutputs.entrySet().stream().filter(previousOutput -> composedStep.executionParameters.entrySet().stream().anyMatch(input -> ((String)input.getKey()).contains("#" + (String)previousOutput.getKey()) || this.usePreviousIterationOutput((String)previousOutput.getKey(), (String)input.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, Integer> findUsageOfPreviousOutputInImplementation(ExecutableComposedStep composedStep, Map<String, Integer> iterationOutputs) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        composedStep.stepImplementation.ifPresent(si -> map.putAll(iterationOutputs.entrySet().stream().filter(previousOutput -> this.contains((String)previousOutput.getKey(), si.inputs) || this.contains((String)previousOutput.getKey(), si.outputs)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
        return map;
    }

    private boolean contains(String previousOutput, Map<String, Object> map) {
        return map.entrySet().stream().anyMatch(entry -> ((String)entry.getKey()).contains("#" + previousOutput) || this.usePreviousIterationOutput(previousOutput, entry.getValue()));
    }

    private boolean usePreviousIterationOutput(String previousOutput, Object value) {
        if (value instanceof String) {
            return this.usePreviousIterationOutput(previousOutput, (String)value);
        }
        if (value instanceof Map) {
            return this.usePreviousIterationOutput(previousOutput, (Map)value);
        }
        return false;
    }

    private boolean usePreviousIterationOutput(String previousOutput, String value) {
        return value.contains("#" + previousOutput);
    }

    private boolean usePreviousIterationOutput(String previousOutput, Map<String, String> value) {
        return value.entrySet().stream().anyMatch(e -> ((String)e.getKey()).contains("#" + previousOutput) || this.usePreviousIterationOutput(previousOutput, (String)e.getValue()));
    }

    private Set<String> findHeadersReferencesWithinEmptyParametersKey(Map<String, String> executionParameters, List<String> matchedHeaders) {
        return executionParameters.entrySet().stream().filter(e -> ((String)e.getValue()).isEmpty() && matchedHeaders.contains(e.getKey())).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private Map<String, Set<String>> findHeadersReferencesWithinParameterValues(Map<String, String> executionParameters, List<String> matchedHeaders) {
        HashMap<String, Set<String>> executionParametersReferencingDatableHeader = new HashMap<String, Set<String>>();
        for (Map.Entry<String, String> parameter : executionParameters.entrySet()) {
            String value = parameter.getValue();
            for (String matchedHeader : matchedHeaders) {
                if (!value.contains("**" + matchedHeader + "**")) continue;
                executionParametersReferencingDatableHeader.putIfAbsent(parameter.getKey(), new HashSet());
                executionParametersReferencingDatableHeader.get(parameter.getKey()).add(matchedHeader);
            }
        }
        return executionParametersReferencingDatableHeader;
    }

    private List<ExecutableComposedStep> buildStepIterations(ExecutableComposedStep composedStep, List<Map<String, String>> datatable, Set<String> csNovaluedEntries, Map<String, Set<String>> executionParametersReferencingDatableHeader, Map<String, Integer> iterationOutputs) {
        AtomicInteger index = new AtomicInteger(0);
        List<ExecutableComposedStep> iterations = this.generateIterationsForDatatable(composedStep, datatable, csNovaluedEntries, executionParametersReferencingDatableHeader, iterationOutputs, index);
        if (iterations.isEmpty()) {
            iterations = this.generateIterationsForPreviousIterationOutputs(composedStep, iterationOutputs, index);
        }
        if (iterations.isEmpty()) {
            iterations = this.generateIterationsForPreviousIterationOutputsInDataset(composedStep, iterationOutputs, index);
        }
        this.rememberIterationsCountForEachOutput(iterationOutputs, index);
        this.updateIndexedOutputsUsingExecutionParameterValues(iterationOutputs, composedStep);
        return iterations;
    }

    private List<ExecutableComposedStep> generateIterationsForDatatable(ExecutableComposedStep composedStep, List<Map<String, String>> datatable, Set<String> csNovaluedEntries, Map<String, Set<String>> executionParametersReferencingDatableHeader, Map<String, Integer> iterationOutputs, AtomicInteger index) {
        List<Map<String, String>> iterationData = this.findUsageOfDatasetDatatable(csNovaluedEntries, executionParametersReferencingDatableHeader, datatable);
        return iterationData.stream().map(mv -> {
            index.getAndIncrement();
            return ExecutableComposedStep.builder().from(composedStep).withImplementation(composedStep.stepImplementation.flatMap(si -> Optional.of(this.indexIterationIO((StepImplementation)si, index, iterationOutputs)))).withName(composedStep.name + " - datatable iteration " + index).withExecutionParameters(this.applyIndexedOutputs(this.updatedExecutionParametersUsingCurrentValue(composedStep.executionParameters, csNovaluedEntries, executionParametersReferencingDatableHeader, (Map<String, String>)mv), index, iterationOutputs)).withSteps(composedStep.steps.stream().map(s -> ExecutableComposedStep.builder().from((ExecutableComposedStep)s).withImplementation(s.stepImplementation.flatMap(si -> Optional.of(this.indexIterationIO((StepImplementation)si, index, iterationOutputs)))).withExecutionParameters(this.applyIndexedOutputs(s.executionParameters, index, iterationOutputs)).build()).collect(Collectors.toList())).build();
        }).collect(Collectors.toList());
    }

    private List<Map<String, String>> findUsageOfDatasetDatatable(Set<String> csNovaluedEntries, Map<String, Set<String>> csValuedEntriesWithRef, List<Map<String, String>> datatable) {
        Set dataSetEntriesReferenced = csValuedEntriesWithRef.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        return datatable.stream().map(mv -> mv.entrySet().stream().filter(e -> csNovaluedEntries.contains(e.getKey()) || dataSetEntriesReferenced.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).distinct().filter(mv -> !mv.isEmpty()).collect(Collectors.toList());
    }

    private List<ExecutableComposedStep> generateIterationsForPreviousIterationOutputs(ExecutableComposedStep composedStep, Map<String, Integer> iterationOutputs, AtomicInteger index) {
        Map<String, Integer> previousOutputs = this.findUsageOfPreviousOutputInImplementation(composedStep, iterationOutputs);
        int iterationsCount = previousOutputs.values().stream().findFirst().orElse(0);
        ArrayList<ExecutableComposedStep> generatedIterations = new ArrayList<ExecutableComposedStep>();
        for (int i = 0; i < iterationsCount; ++i) {
            index.getAndIncrement();
            generatedIterations.add(ExecutableComposedStep.builder().from(composedStep).withImplementation(composedStep.stepImplementation.flatMap(si -> Optional.of(this.indexIterationIO((StepImplementation)si, index, iterationOutputs)))).withName(composedStep.name + " - datatable iteration " + index).withExecutionParameters(composedStep.executionParameters).build());
        }
        return generatedIterations;
    }

    private List<ExecutableComposedStep> generateIterationsForPreviousIterationOutputsInDataset(ExecutableComposedStep composedStep, Map<String, Integer> iterationOutputs, AtomicInteger index) {
        Map<String, Integer> previousOutputs = this.findUsageOfPreviousOutputInExecutionParameters(composedStep, iterationOutputs);
        int iterationsCount = previousOutputs.values().stream().findFirst().orElse(0);
        ArrayList<ExecutableComposedStep> generatedIterations = new ArrayList<ExecutableComposedStep>();
        for (int i = 0; i < iterationsCount; ++i) {
            index.getAndIncrement();
            generatedIterations.add(ExecutableComposedStep.builder().from(composedStep).withImplementation(composedStep.stepImplementation.flatMap(si -> Optional.of(this.indexIterationIO((StepImplementation)si, index, iterationOutputs)))).withName(composedStep.name + " - datatable iteration " + index).withExecutionParameters(this.applyIndexedOutputs(composedStep.executionParameters, index, iterationOutputs)).build());
        }
        return generatedIterations;
    }

    private Map<String, String> updatedExecutionParametersUsingCurrentValue(Map<String, String> executionParameters, Set<String> csNovaluedEntries, Map<String, Set<String>> executionParametersReferencingDatableHeader, Map<String, String> mv) {
        HashMap<String, String> newExecutionParameters = new HashMap<String, String>(executionParameters);
        executionParameters.forEach((k, v) -> {
            if (csNovaluedEntries.contains(k)) {
                newExecutionParameters.put((String)k, (String)mv.get(k));
            } else if (executionParametersReferencingDatableHeader.containsKey(k)) {
                newExecutionParameters.put((String)k, this.replaceParams((String)v, Collections.emptyMap(), mv));
            }
        });
        return newExecutionParameters;
    }

    private StepImplementation indexIterationIO(StepImplementation si, AtomicInteger index, Map<String, Integer> iterationOutputs) {
        this.rememberIndexedOutput(iterationOutputs, si.outputs);
        return new StepImplementation(si.type, si.target, this.indexInputs(si.inputs, index, iterationOutputs), this.indexOutputs(si.outputs, index, iterationOutputs), si.validations);
    }

    private void rememberIndexedOutput(Map<String, Integer> iterationOutputs, Map<String, Object> outputs) {
        Map<String, Integer> collect = outputs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> 0));
        iterationOutputs.putAll(collect);
    }

    private void rememberIterationsCountForEachOutput(Map<String, Integer> iterationOutputs, AtomicInteger index) {
        iterationOutputs.replaceAll((k, v) -> {
            v = index.get();
            return v;
        });
    }

    private void updateIndexedOutputsUsingExecutionParameterValues(Map<String, Integer> iterationOutputs, ExecutableComposedStep composedStep) {
        ArrayList<ExecutableComposedStep> steps = new ArrayList<ExecutableComposedStep>(composedStep.steps);
        Collections.reverse(steps);
        steps.forEach(executableComposedStep -> this.updateIndexedOutputsUsingExecutionParameterValues(iterationOutputs, (ExecutableComposedStep)executableComposedStep));
        composedStep.executionParameters.entrySet().stream().filter(entry -> iterationOutputs.containsKey("**" + (String)entry.getKey() + "**")).forEach(entry -> {
            Integer iterationsCount = (Integer)iterationOutputs.get("**" + (String)entry.getKey() + "**");
            iterationOutputs.remove("**" + (String)entry.getKey() + "**");
            iterationOutputs.put(composedStep.executionParameters.get(entry.getKey()), iterationsCount);
        });
    }

    private void removeObsoleteIndexedOutputs(Map<String, Integer> iterationOutputs, ExecutableComposedStep composedStep) {
        ArrayList list = new ArrayList();
        composedStep.stepImplementation.ifPresent(si -> list.addAll(si.outputs.keySet()));
        if (list.isEmpty()) {
            composedStep.steps.forEach(executableComposedStep -> this.removeObsoleteIndexedOutputs(iterationOutputs, (ExecutableComposedStep)executableComposedStep));
        } else {
            composedStep.executionParameters.entrySet().stream().filter(entry -> list.contains("**" + (String)entry.getKey() + "**")).forEach(entry -> {
                list.remove("**" + (String)entry.getKey() + "**");
                list.add((String)entry.getValue());
            });
            list.stream().filter(iterationOutputs::containsKey).forEach(iterationOutputs::remove);
        }
    }

    private Map<String, Object> indexInputs(Map<String, Object> inputs, AtomicInteger index, Map<String, Integer> iterationOutputs) {
        return inputs.entrySet().stream().collect(HashMap::new, (m, e) -> m.put(this.applyIndexedOutputsOnStringValue((String)e.getKey(), index, iterationOutputs), this.applyIndexedOutputs(e.getValue(), index, iterationOutputs)), HashMap::putAll);
    }

    private Map<String, Object> indexOutputs(Map<String, Object> outputs, AtomicInteger index, Map<String, Integer> iterationOutputs) {
        return outputs.entrySet().stream().collect(HashMap::new, (m, e) -> m.put((String)e.getKey() + "_" + index, this.applyIndexedOutputs(e.getValue(), index, iterationOutputs)), HashMap::putAll);
    }

    private Object applyIndexedOutputs(Object value, AtomicInteger index, Map<String, Integer> indexedOutput) {
        if (value instanceof String) {
            return this.applyIndexedOutputsOnStringValue((String)value, index, indexedOutput);
        }
        if (value instanceof Map) {
            return this.applyIndexedOutputs((Map)value, index, indexedOutput);
        }
        return value;
    }

    private Map<String, String> applyIndexedOutputs(Map<String, String> value, AtomicInteger index, Map<String, Integer> indexedOutput) {
        return value.entrySet().parallelStream().collect(Collectors.toMap(e -> this.applyIndexedOutputsOnStringValue((String)e.getKey(), index, indexedOutput), e -> this.applyIndexedOutputsOnStringValue((String)e.getValue(), index, indexedOutput)));
    }

    private String applyIndexedOutputsOnStringValue(String value, AtomicInteger index, Map<String, Integer> indexedOutput) {
        String tmp = value;
        for (String output : indexedOutput.keySet()) {
            Pattern pattern = Pattern.compile("#" + Pattern.quote(output) + "\\b");
            Matcher matcher = pattern.matcher(tmp);
            if (!matcher.find()) continue;
            tmp = matcher.replaceAll("#" + StringEscapeUtils.escapeJson((String)(output + "_" + index)));
        }
        return tmp;
    }

    private Map<String, String> buildExecutionParametersWithAliases(Map<String, String> executionParameters) {
        Map<String, String> aliases = executionParameters.entrySet().stream().filter(e -> this.isAlias((String)e.getValue())).collect(Collectors.toMap(a -> ((String)a.getValue()).substring(2, ((String)a.getValue()).length() - 2), o -> ""));
        aliases.putAll(executionParameters);
        return Collections.unmodifiableMap(aliases);
    }

    private boolean isAlias(String paramValue) {
        return this.aliasPattern.matcher(paramValue).matches();
    }
}

