/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.component.scenario.infra;

import com.chutneytesting.component.ComposableIdUtils;
import com.chutneytesting.component.scenario.domain.ComposableScenario;
import com.chutneytesting.component.scenario.domain.ComposableStep;
import com.chutneytesting.component.scenario.domain.ComposableTestCase;
import com.chutneytesting.component.scenario.infra.OrientComposableStepMapper;
import com.chutneytesting.component.scenario.infra.wrapper.TestCaseVertex;
import com.chutneytesting.server.core.domain.scenario.TestCaseMetadata;
import com.chutneytesting.server.core.domain.scenario.TestCaseMetadataImpl;
import com.orientechnologies.orient.core.record.OVertex;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

class OrientComposableTestCaseMapper {
    OrientComposableTestCaseMapper() {
    }

    static TestCaseVertex testCaseToVertex(ComposableTestCase composableTestCase, OVertex dbTestCase) {
        String internalId = ComposableIdUtils.toInternalId(composableTestCase.id);
        return TestCaseVertex.builder().from(dbTestCase).withId(internalId).withTitle(composableTestCase.metadata.title()).withDescription(composableTestCase.metadata.description()).withCreationDate(Date.from(composableTestCase.metadata.creationDate())).withTags(composableTestCase.metadata.tags()).withParameters(composableTestCase.composableScenario.parameters).withDatasetId(composableTestCase.metadata.defaultDataset()).withUpdateDate(Date.from(Instant.now())).withAuthor(composableTestCase.metadata.author()).withSteps(OrientComposableTestCaseMapper.convertIds(composableTestCase.composableScenario.composableSteps)).build();
    }

    private static List<ComposableStep> convertIds(List<ComposableStep> composableSteps) {
        return composableSteps.stream().map(cs -> ComposableStep.builder().from((ComposableStep)cs).withId(ComposableIdUtils.toInternalId(cs.id)).withSteps(OrientComposableTestCaseMapper.convertIds(cs.steps)).withExecutionParameters(cs.executionParameters).build()).collect(Collectors.toList());
    }

    static ComposableTestCase vertexToTestCase(TestCaseVertex testCaseVertex) {
        String externalId = ComposableIdUtils.toExternalId(testCaseVertex.id());
        TestCaseMetadataImpl metadata = TestCaseMetadataImpl.builder().withId(externalId).withTitle(testCaseVertex.title()).withDescription(testCaseVertex.description()).withCreationDate(testCaseVertex.creationDate()).withTags(testCaseVertex.tags()).withDefaultDataset(testCaseVertex.datasetId()).withUpdateDate(testCaseVertex.updateDate()).withAuthor(testCaseVertex.author()).withVersion(testCaseVertex.version()).build();
        ComposableScenario scenario = ComposableScenario.builder().withComposableSteps(OrientComposableStepMapper.vertexToComposableStep(testCaseVertex.scenario())).withParameters(testCaseVertex.parameters()).build();
        return new ComposableTestCase(externalId, (TestCaseMetadata)metadata, scenario);
    }
}

