/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.component.scenario.api.dto;

import com.chutneytesting.component.scenario.api.dto.ComposableTestCaseDto;
import com.chutneytesting.server.core.domain.tools.ui.KeyValue;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="ComposableTestCaseDto", generator="Immutables")
@Immutable
public final class ImmutableComposableTestCaseDto
implements ComposableTestCaseDto {
    @Nullable
    private final String id;
    private final String title;
    @Nullable
    private final String description;
    private final Instant creationDate;
    private final List<String> tags;
    private final ComposableTestCaseDto.ComposableScenarioDto scenario;
    @Nullable
    private final String datasetId;
    private final String author;
    private final Instant updateDate;
    private final Integer version;
    private final List<KeyValue> executionParameters;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableComposableTestCaseDto(Builder builder) {
        this.id = builder.id;
        this.title = builder.title;
        this.description = builder.description;
        this.tags = ImmutableComposableTestCaseDto.createUnmodifiableList(true, builder.tags);
        this.scenario = builder.scenario;
        this.datasetId = builder.datasetId;
        if (builder.creationDate != null) {
            this.initShim.creationDate(builder.creationDate);
        }
        if (builder.author != null) {
            this.initShim.author(builder.author);
        }
        if (builder.updateDate != null) {
            this.initShim.updateDate(builder.updateDate);
        }
        if (builder.version != null) {
            this.initShim.version(builder.version);
        }
        if (builder.executionParametersIsSet()) {
            this.initShim.executionParameters(ImmutableComposableTestCaseDto.createUnmodifiableList(true, builder.executionParameters));
        }
        this.creationDate = this.initShim.creationDate();
        this.author = this.initShim.author();
        this.updateDate = this.initShim.updateDate();
        this.version = this.initShim.version();
        this.executionParameters = this.initShim.executionParameters();
        this.initShim = null;
    }

    private ImmutableComposableTestCaseDto(@Nullable String id, String title, @Nullable String description, Instant creationDate, List<String> tags, ComposableTestCaseDto.ComposableScenarioDto scenario, @Nullable String datasetId, String author, Instant updateDate, Integer version, List<KeyValue> executionParameters) {
        this.id = id;
        this.title = title;
        this.description = description;
        this.creationDate = creationDate;
        this.tags = tags;
        this.scenario = scenario;
        this.datasetId = datasetId;
        this.author = author;
        this.updateDate = updateDate;
        this.version = version;
        this.executionParameters = executionParameters;
        this.initShim = null;
    }

    private Instant creationDateInitialize() {
        return ComposableTestCaseDto.super.creationDate();
    }

    private String authorInitialize() {
        return ComposableTestCaseDto.super.author();
    }

    private Instant updateDateInitialize() {
        return ComposableTestCaseDto.super.updateDate();
    }

    private Integer versionInitialize() {
        return ComposableTestCaseDto.super.version();
    }

    private List<KeyValue> executionParametersInitialize() {
        return ComposableTestCaseDto.super.executionParameters();
    }

    @Override
    @JsonProperty(value="id")
    public Optional<String> id() {
        return Optional.ofNullable(this.id);
    }

    @Override
    @JsonProperty(value="title")
    public String title() {
        return this.title;
    }

    @Override
    @JsonProperty(value="description")
    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    @Override
    @JsonProperty(value="creationDate")
    public Instant creationDate() {
        InitShim shim = this.initShim;
        return shim != null ? shim.creationDate() : this.creationDate;
    }

    @Override
    @JsonProperty(value="tags")
    public List<String> tags() {
        return this.tags;
    }

    @Override
    @JsonProperty(value="scenario")
    public ComposableTestCaseDto.ComposableScenarioDto scenario() {
        return this.scenario;
    }

    @Override
    @JsonProperty(value="datasetId")
    public Optional<String> datasetId() {
        return Optional.ofNullable(this.datasetId);
    }

    @Override
    @JsonProperty(value="author")
    public String author() {
        InitShim shim = this.initShim;
        return shim != null ? shim.author() : this.author;
    }

    @Override
    @JsonProperty(value="updateDate")
    public Instant updateDate() {
        InitShim shim = this.initShim;
        return shim != null ? shim.updateDate() : this.updateDate;
    }

    @Override
    @JsonProperty(value="version")
    public Integer version() {
        InitShim shim = this.initShim;
        return shim != null ? shim.version() : this.version;
    }

    @Override
    @JsonProperty(value="computedParameters")
    public List<KeyValue> executionParameters() {
        InitShim shim = this.initShim;
        return shim != null ? shim.executionParameters() : this.executionParameters;
    }

    public final ImmutableComposableTestCaseDto withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (Objects.equals(this.id, newValue)) {
            return this;
        }
        return new ImmutableComposableTestCaseDto(newValue, this.title, this.description, this.creationDate, this.tags, this.scenario, this.datasetId, this.author, this.updateDate, this.version, this.executionParameters);
    }

    public final ImmutableComposableTestCaseDto withId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableComposableTestCaseDto(value, this.title, this.description, this.creationDate, this.tags, this.scenario, this.datasetId, this.author, this.updateDate, this.version, this.executionParameters);
    }

    public final ImmutableComposableTestCaseDto withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableComposableTestCaseDto(this.id, newValue, this.description, this.creationDate, this.tags, this.scenario, this.datasetId, this.author, this.updateDate, this.version, this.executionParameters);
    }

    public final ImmutableComposableTestCaseDto withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return new ImmutableComposableTestCaseDto(this.id, this.title, newValue, this.creationDate, this.tags, this.scenario, this.datasetId, this.author, this.updateDate, this.version, this.executionParameters);
    }

    public final ImmutableComposableTestCaseDto withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableComposableTestCaseDto(this.id, this.title, value, this.creationDate, this.tags, this.scenario, this.datasetId, this.author, this.updateDate, this.version, this.executionParameters);
    }

    public final ImmutableComposableTestCaseDto withCreationDate(Instant value) {
        if (this.creationDate == value) {
            return this;
        }
        Instant newValue = Objects.requireNonNull(value, "creationDate");
        return new ImmutableComposableTestCaseDto(this.id, this.title, this.description, newValue, this.tags, this.scenario, this.datasetId, this.author, this.updateDate, this.version, this.executionParameters);
    }

    public final ImmutableComposableTestCaseDto withTags(String ... elements) {
        List<String> newValue = ImmutableComposableTestCaseDto.createUnmodifiableList(false, ImmutableComposableTestCaseDto.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableComposableTestCaseDto(this.id, this.title, this.description, this.creationDate, newValue, this.scenario, this.datasetId, this.author, this.updateDate, this.version, this.executionParameters);
    }

    public final ImmutableComposableTestCaseDto withTags(Iterable<String> elements) {
        if (this.tags == elements) {
            return this;
        }
        List<String> newValue = ImmutableComposableTestCaseDto.createUnmodifiableList(false, ImmutableComposableTestCaseDto.createSafeList(elements, true, false));
        return new ImmutableComposableTestCaseDto(this.id, this.title, this.description, this.creationDate, newValue, this.scenario, this.datasetId, this.author, this.updateDate, this.version, this.executionParameters);
    }

    public final ImmutableComposableTestCaseDto withScenario(ComposableTestCaseDto.ComposableScenarioDto value) {
        if (this.scenario == value) {
            return this;
        }
        ComposableTestCaseDto.ComposableScenarioDto newValue = Objects.requireNonNull(value, "scenario");
        return new ImmutableComposableTestCaseDto(this.id, this.title, this.description, this.creationDate, this.tags, newValue, this.datasetId, this.author, this.updateDate, this.version, this.executionParameters);
    }

    public final ImmutableComposableTestCaseDto withDatasetId(String value) {
        String newValue = Objects.requireNonNull(value, "datasetId");
        if (Objects.equals(this.datasetId, newValue)) {
            return this;
        }
        return new ImmutableComposableTestCaseDto(this.id, this.title, this.description, this.creationDate, this.tags, this.scenario, newValue, this.author, this.updateDate, this.version, this.executionParameters);
    }

    public final ImmutableComposableTestCaseDto withDatasetId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.datasetId, value)) {
            return this;
        }
        return new ImmutableComposableTestCaseDto(this.id, this.title, this.description, this.creationDate, this.tags, this.scenario, value, this.author, this.updateDate, this.version, this.executionParameters);
    }

    public final ImmutableComposableTestCaseDto withAuthor(String value) {
        String newValue = Objects.requireNonNull(value, "author");
        if (this.author.equals(newValue)) {
            return this;
        }
        return new ImmutableComposableTestCaseDto(this.id, this.title, this.description, this.creationDate, this.tags, this.scenario, this.datasetId, newValue, this.updateDate, this.version, this.executionParameters);
    }

    public final ImmutableComposableTestCaseDto withUpdateDate(Instant value) {
        if (this.updateDate == value) {
            return this;
        }
        Instant newValue = Objects.requireNonNull(value, "updateDate");
        return new ImmutableComposableTestCaseDto(this.id, this.title, this.description, this.creationDate, this.tags, this.scenario, this.datasetId, this.author, newValue, this.version, this.executionParameters);
    }

    public final ImmutableComposableTestCaseDto withVersion(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "version");
        if (this.version.equals(newValue)) {
            return this;
        }
        return new ImmutableComposableTestCaseDto(this.id, this.title, this.description, this.creationDate, this.tags, this.scenario, this.datasetId, this.author, this.updateDate, newValue, this.executionParameters);
    }

    public final ImmutableComposableTestCaseDto withExecutionParameters(KeyValue ... elements) {
        List<KeyValue> newValue = ImmutableComposableTestCaseDto.createUnmodifiableList(false, ImmutableComposableTestCaseDto.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableComposableTestCaseDto(this.id, this.title, this.description, this.creationDate, this.tags, this.scenario, this.datasetId, this.author, this.updateDate, this.version, newValue);
    }

    public final ImmutableComposableTestCaseDto withExecutionParameters(Iterable<? extends KeyValue> elements) {
        if (this.executionParameters == elements) {
            return this;
        }
        List<KeyValue> newValue = ImmutableComposableTestCaseDto.createUnmodifiableList(false, ImmutableComposableTestCaseDto.createSafeList(elements, true, false));
        return new ImmutableComposableTestCaseDto(this.id, this.title, this.description, this.creationDate, this.tags, this.scenario, this.datasetId, this.author, this.updateDate, this.version, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableComposableTestCaseDto && this.equalTo(0, (ImmutableComposableTestCaseDto)another);
    }

    private boolean equalTo(int synthetic, ImmutableComposableTestCaseDto another) {
        return Objects.equals(this.id, another.id) && this.title.equals(another.title) && Objects.equals(this.description, another.description) && this.creationDate.equals(another.creationDate) && this.tags.equals(another.tags) && this.scenario.equals(another.scenario) && Objects.equals(this.datasetId, another.datasetId) && this.author.equals(another.author) && this.updateDate.equals(another.updateDate) && this.version.equals(another.version) && this.executionParameters.equals(another.executionParameters);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + this.creationDate.hashCode();
        h += (h << 5) + this.tags.hashCode();
        h += (h << 5) + this.scenario.hashCode();
        h += (h << 5) + Objects.hashCode(this.datasetId);
        h += (h << 5) + this.author.hashCode();
        h += (h << 5) + this.updateDate.hashCode();
        h += (h << 5) + this.version.hashCode();
        h += (h << 5) + this.executionParameters.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ComposableTestCaseDto{");
        if (this.id != null) {
            builder.append("id=").append(this.id);
        }
        if (builder.length() > 22) {
            builder.append(", ");
        }
        builder.append("title=").append(this.title);
        if (this.description != null) {
            builder.append(", ");
            builder.append("description=").append(this.description);
        }
        builder.append(", ");
        builder.append("creationDate=").append(this.creationDate);
        builder.append(", ");
        builder.append("tags=").append(this.tags);
        builder.append(", ");
        builder.append("scenario=").append(this.scenario);
        if (this.datasetId != null) {
            builder.append(", ");
            builder.append("datasetId=").append(this.datasetId);
        }
        builder.append(", ");
        builder.append("author=").append(this.author);
        builder.append(", ");
        builder.append("updateDate=").append(this.updateDate);
        builder.append(", ");
        builder.append("version=").append(this.version);
        builder.append(", ");
        builder.append("executionParameters=").append(this.executionParameters);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableComposableTestCaseDto fromJson(Json json) {
        Builder builder = ImmutableComposableTestCaseDto.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.title != null) {
            builder.title(json.title);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.creationDate != null) {
            builder.creationDate(json.creationDate);
        }
        if (json.tags != null) {
            builder.addAllTags(json.tags);
        }
        if (json.scenario != null) {
            builder.scenario(json.scenario);
        }
        if (json.datasetId != null) {
            builder.datasetId(json.datasetId);
        }
        if (json.author != null) {
            builder.author(json.author);
        }
        if (json.updateDate != null) {
            builder.updateDate(json.updateDate);
        }
        if (json.version != null) {
            builder.version(json.version);
        }
        if (json.executionParametersIsSet) {
            builder.addAllExecutionParameters(json.executionParameters);
        }
        return builder.build();
    }

    public static ImmutableComposableTestCaseDto copyOf(ComposableTestCaseDto instance) {
        if (instance instanceof ImmutableComposableTestCaseDto) {
            return (ImmutableComposableTestCaseDto)instance;
        }
        return ImmutableComposableTestCaseDto.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ComposableTestCaseDto", generator="Immutables")
    private final class InitShim {
        private byte creationDateBuildStage = 0;
        private Instant creationDate;
        private byte authorBuildStage = 0;
        private String author;
        private byte updateDateBuildStage = 0;
        private Instant updateDate;
        private byte versionBuildStage = 0;
        private Integer version;
        private byte executionParametersBuildStage = 0;
        private List<KeyValue> executionParameters;

        private InitShim() {
        }

        Instant creationDate() {
            if (this.creationDateBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.creationDateBuildStage == 0) {
                this.creationDateBuildStage = (byte)-1;
                this.creationDate = Objects.requireNonNull(ImmutableComposableTestCaseDto.this.creationDateInitialize(), "creationDate");
                this.creationDateBuildStage = 1;
            }
            return this.creationDate;
        }

        void creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            this.creationDateBuildStage = 1;
        }

        String author() {
            if (this.authorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.authorBuildStage == 0) {
                this.authorBuildStage = (byte)-1;
                this.author = Objects.requireNonNull(ImmutableComposableTestCaseDto.this.authorInitialize(), "author");
                this.authorBuildStage = 1;
            }
            return this.author;
        }

        void author(String author) {
            this.author = author;
            this.authorBuildStage = 1;
        }

        Instant updateDate() {
            if (this.updateDateBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.updateDateBuildStage == 0) {
                this.updateDateBuildStage = (byte)-1;
                this.updateDate = Objects.requireNonNull(ImmutableComposableTestCaseDto.this.updateDateInitialize(), "updateDate");
                this.updateDateBuildStage = 1;
            }
            return this.updateDate;
        }

        void updateDate(Instant updateDate) {
            this.updateDate = updateDate;
            this.updateDateBuildStage = 1;
        }

        Integer version() {
            if (this.versionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.versionBuildStage == 0) {
                this.versionBuildStage = (byte)-1;
                this.version = Objects.requireNonNull(ImmutableComposableTestCaseDto.this.versionInitialize(), "version");
                this.versionBuildStage = 1;
            }
            return this.version;
        }

        void version(Integer version) {
            this.version = version;
            this.versionBuildStage = 1;
        }

        List<KeyValue> executionParameters() {
            if (this.executionParametersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.executionParametersBuildStage == 0) {
                this.executionParametersBuildStage = (byte)-1;
                this.executionParameters = ImmutableComposableTestCaseDto.createUnmodifiableList(false, ImmutableComposableTestCaseDto.createSafeList(ImmutableComposableTestCaseDto.this.executionParametersInitialize(), true, false));
                this.executionParametersBuildStage = 1;
            }
            return this.executionParameters;
        }

        void executionParameters(List<KeyValue> executionParameters) {
            this.executionParameters = executionParameters;
            this.executionParametersBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.creationDateBuildStage == -1) {
                attributes.add("creationDate");
            }
            if (this.authorBuildStage == -1) {
                attributes.add("author");
            }
            if (this.updateDateBuildStage == -1) {
                attributes.add("updateDate");
            }
            if (this.versionBuildStage == -1) {
                attributes.add("version");
            }
            if (this.executionParametersBuildStage == -1) {
                attributes.add("executionParameters");
            }
            return "Cannot build ComposableTestCaseDto, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="ComposableTestCaseDto", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TITLE = 1L;
        private static final long INIT_BIT_SCENARIO = 2L;
        private static final long OPT_BIT_EXECUTION_PARAMETERS = 1L;
        private long initBits = 3L;
        private long optBits;
        @Nullable
        private String id;
        @Nullable
        private String title;
        @Nullable
        private String description;
        @Nullable
        private Instant creationDate;
        private List<String> tags = new ArrayList<String>();
        @Nullable
        private ComposableTestCaseDto.ComposableScenarioDto scenario;
        @Nullable
        private String datasetId;
        @Nullable
        private String author;
        @Nullable
        private Instant updateDate;
        @Nullable
        private Integer version;
        private List<KeyValue> executionParameters = new ArrayList<KeyValue>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ComposableTestCaseDto instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<String> idOptional = instance.id();
            if (idOptional.isPresent()) {
                this.id(idOptional);
            }
            this.title(instance.title());
            Optional<String> descriptionOptional = instance.description();
            if (descriptionOptional.isPresent()) {
                this.description(descriptionOptional);
            }
            this.creationDate(instance.creationDate());
            this.addAllTags(instance.tags());
            this.scenario(instance.scenario());
            Optional<String> datasetIdOptional = instance.datasetId();
            if (datasetIdOptional.isPresent()) {
                this.datasetId(datasetIdOptional);
            }
            this.author(instance.author());
            this.updateDate(instance.updateDate());
            this.version(instance.version());
            this.addAllExecutionParameters(instance.executionParameters());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(Optional<String> id) {
            this.id = id.orElse(null);
            return this;
        }

        @JsonProperty(value="title")
        @CanIgnoreReturnValue
        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty(value="description")
        @CanIgnoreReturnValue
        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        @JsonProperty(value="creationDate")
        @CanIgnoreReturnValue
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = Objects.requireNonNull(creationDate, "creationDate");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTags(String element) {
            this.tags.add(Objects.requireNonNull(element, "tags element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTags(String ... elements) {
            for (String element : elements) {
                this.tags.add(Objects.requireNonNull(element, "tags element"));
            }
            return this;
        }

        @JsonProperty(value="tags")
        @CanIgnoreReturnValue
        public final Builder tags(Iterable<String> elements) {
            this.tags.clear();
            return this.addAllTags(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTags(Iterable<String> elements) {
            for (String element : elements) {
                this.tags.add(Objects.requireNonNull(element, "tags element"));
            }
            return this;
        }

        @JsonProperty(value="scenario")
        @CanIgnoreReturnValue
        public final Builder scenario(ComposableTestCaseDto.ComposableScenarioDto scenario) {
            this.scenario = Objects.requireNonNull(scenario, "scenario");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder datasetId(String datasetId) {
            this.datasetId = Objects.requireNonNull(datasetId, "datasetId");
            return this;
        }

        @JsonProperty(value="datasetId")
        @CanIgnoreReturnValue
        public final Builder datasetId(Optional<String> datasetId) {
            this.datasetId = datasetId.orElse(null);
            return this;
        }

        @JsonProperty(value="author")
        @CanIgnoreReturnValue
        public final Builder author(String author) {
            this.author = Objects.requireNonNull(author, "author");
            return this;
        }

        @JsonProperty(value="updateDate")
        @CanIgnoreReturnValue
        public final Builder updateDate(Instant updateDate) {
            this.updateDate = Objects.requireNonNull(updateDate, "updateDate");
            return this;
        }

        @JsonProperty(value="version")
        @CanIgnoreReturnValue
        public final Builder version(Integer version) {
            this.version = Objects.requireNonNull(version, "version");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExecutionParameters(KeyValue element) {
            this.executionParameters.add(Objects.requireNonNull(element, "executionParameters element"));
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExecutionParameters(KeyValue ... elements) {
            for (KeyValue element : elements) {
                this.executionParameters.add(Objects.requireNonNull(element, "executionParameters element"));
            }
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="computedParameters")
        @CanIgnoreReturnValue
        public final Builder executionParameters(Iterable<? extends KeyValue> elements) {
            this.executionParameters.clear();
            return this.addAllExecutionParameters(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllExecutionParameters(Iterable<? extends KeyValue> elements) {
            for (KeyValue keyValue : elements) {
                this.executionParameters.add(Objects.requireNonNull(keyValue, "executionParameters element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public ImmutableComposableTestCaseDto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableComposableTestCaseDto(this);
        }

        private boolean executionParametersIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("title");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("scenario");
            }
            return "Cannot build ComposableTestCaseDto, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ComposableTestCaseDto", generator="Immutables")
    static final class Json
    implements ComposableTestCaseDto {
        @Nullable
        Optional<String> id = Optional.empty();
        @Nullable
        String title;
        @Nullable
        Optional<String> description = Optional.empty();
        @Nullable
        Instant creationDate;
        @Nullable
        List<String> tags = Collections.emptyList();
        @Nullable
        ComposableTestCaseDto.ComposableScenarioDto scenario;
        @Nullable
        Optional<String> datasetId = Optional.empty();
        @Nullable
        String author;
        @Nullable
        Instant updateDate;
        @Nullable
        Integer version;
        @Nullable
        List<KeyValue> executionParameters = Collections.emptyList();
        boolean executionParametersIsSet;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(Optional<String> id) {
            this.id = id;
        }

        @JsonProperty(value="title")
        public void setTitle(String title) {
            this.title = title;
        }

        @JsonProperty(value="description")
        public void setDescription(Optional<String> description) {
            this.description = description;
        }

        @JsonProperty(value="creationDate")
        public void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @JsonProperty(value="tags")
        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="scenario")
        public void setScenario(ComposableTestCaseDto.ComposableScenarioDto scenario) {
            this.scenario = scenario;
        }

        @JsonProperty(value="datasetId")
        public void setDatasetId(Optional<String> datasetId) {
            this.datasetId = datasetId;
        }

        @JsonProperty(value="author")
        public void setAuthor(String author) {
            this.author = author;
        }

        @JsonProperty(value="updateDate")
        public void setUpdateDate(Instant updateDate) {
            this.updateDate = updateDate;
        }

        @JsonProperty(value="version")
        public void setVersion(Integer version) {
            this.version = version;
        }

        @JsonProperty(value="computedParameters")
        public void setExecutionParameters(List<KeyValue> executionParameters) {
            this.executionParameters = executionParameters;
            this.executionParametersIsSet = true;
        }

        @Override
        public Optional<String> id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String title() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant creationDate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> tags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ComposableTestCaseDto.ComposableScenarioDto scenario() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> datasetId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String author() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant updateDate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer version() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<KeyValue> executionParameters() {
            throw new UnsupportedOperationException();
        }
    }
}

