/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.component.execution.infra;

import com.chutneytesting.agent.domain.explore.CurrentNetworkDescription;
import com.chutneytesting.agent.domain.network.Agent;
import com.chutneytesting.agent.domain.network.NetworkDescription;
import com.chutneytesting.component.execution.domain.ExecutableComposedStep;
import com.chutneytesting.component.execution.domain.ExecutableComposedTestCase;
import com.chutneytesting.engine.api.execution.DatasetDto;
import com.chutneytesting.engine.api.execution.ExecutionRequestDto;
import com.chutneytesting.engine.api.execution.TargetExecutionDto;
import com.chutneytesting.engine.domain.delegation.NamedHostAndPort;
import com.chutneytesting.environment.api.EmbeddedEnvironmentApi;
import com.chutneytesting.environment.api.EnvironmentApi;
import com.chutneytesting.environment.api.dto.NoTargetDto;
import com.chutneytesting.environment.api.dto.TargetDto;
import com.chutneytesting.execution.infra.execution.DefaultExecutionRequestMapper;
import com.chutneytesting.execution.infra.execution.ExecutionRequestMapper;
import com.chutneytesting.scenario.domain.gwt.Strategy;
import com.chutneytesting.server.core.domain.execution.ExecutionRequest;
import com.chutneytesting.server.core.domain.execution.ScenarioConversionException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Primary
@Component
public class ComponentExecutionRequestMapper
implements ExecutionRequestMapper {
    private final EnvironmentApi environmentApi;
    private final CurrentNetworkDescription currentNetworkDescription;
    private final DefaultExecutionRequestMapper defaultExecutionRequestMapper;

    public ComponentExecutionRequestMapper(ObjectMapper objectMapper, EmbeddedEnvironmentApi environmentApi, CurrentNetworkDescription currentNetworkDescription) {
        this.environmentApi = environmentApi;
        this.currentNetworkDescription = currentNetworkDescription;
        this.defaultExecutionRequestMapper = new DefaultExecutionRequestMapper(objectMapper, environmentApi, currentNetworkDescription);
    }

    public ExecutionRequestDto toDto(ExecutionRequest executionRequest) {
        if (executionRequest.testCase.id().contains("-")) {
            ExecutionRequestDto.StepDefinitionRequestDto stepDefinitionRequestDto = this.convertToStepDef(executionRequest);
            return new ExecutionRequestDto(stepDefinitionRequestDto, executionRequest.environment, new DatasetDto(executionRequest.dataset.constants, executionRequest.dataset.datatable));
        }
        return this.defaultExecutionRequestMapper.toDto(executionRequest);
    }

    private ExecutionRequestDto.StepDefinitionRequestDto convertToStepDef(ExecutionRequest executionRequest) {
        if (executionRequest.testCase.id().contains("-")) {
            return this.convertComposed(executionRequest);
        }
        throw new ScenarioConversionException(executionRequest.testCase.metadata().id(), "Cannot create an executable StepDefinition from a " + executionRequest.testCase.getClass().getCanonicalName());
    }

    private ExecutionRequestDto.StepDefinitionRequestDto convertComposed(ExecutionRequest executionRequest) {
        ExecutableComposedTestCase composedTestCase = (ExecutableComposedTestCase)executionRequest.testCase;
        try {
            return new ExecutionRequestDto.StepDefinitionRequestDto(composedTestCase.metadata.title(), this.toExecutionTargetDto(NoTargetDto.NO_TARGET_DTO, executionRequest.environment), null, null, null, this.convertComposedSteps(composedTestCase.composedScenario.composedSteps, executionRequest.environment), null, null);
        }
        catch (Exception e) {
            throw new ScenarioConversionException(composedTestCase.metadata().id(), e);
        }
    }

    private List<ExecutionRequestDto.StepDefinitionRequestDto> convertComposedSteps(List<ExecutableComposedStep> composedSteps, String env) {
        return composedSteps.stream().map(f -> this.convert((ExecutableComposedStep)f, env)).collect(Collectors.toList());
    }

    private ExecutionRequestDto.StepDefinitionRequestDto convert(ExecutableComposedStep composedStep, String env) {
        return new ExecutionRequestDto.StepDefinitionRequestDto(composedStep.name, this.toExecutionTargetDto(this.getTargetForExecution(env, composedStep.stepImplementation.map(si -> si.target).orElse("")), env), this.mapStrategy(composedStep.strategy), composedStep.stepImplementation.map(si -> si.type).orElse(""), composedStep.stepImplementation.map(si -> si.inputs).orElse(Collections.emptyMap()), composedStep.steps.stream().map(f -> this.convert((ExecutableComposedStep)f, env)).collect(Collectors.toList()), composedStep.stepImplementation.map(si -> si.outputs).orElse(Collections.emptyMap()), composedStep.stepImplementation.map(si -> si.validations).orElse(Collections.emptyMap()));
    }

    private ExecutionRequestDto.StepStrategyDefinitionRequestDto mapStrategy(Strategy strategy) {
        return new ExecutionRequestDto.StepStrategyDefinitionRequestDto(strategy.type, strategy.parameters);
    }

    private TargetExecutionDto toExecutionTargetDto(TargetDto targetDto, String env) {
        if (targetDto == null || NoTargetDto.NO_TARGET_DTO.equals(targetDto)) {
            targetDto = NoTargetDto.NO_TARGET_DTO;
        }
        return new TargetExecutionDto(targetDto.name, targetDto.url, targetDto.propertiesToMap(), this.getAgents(targetDto, env));
    }

    private TargetDto getTargetForExecution(String environmentName, String targetName) {
        if (StringUtils.isBlank((CharSequence)targetName)) {
            return NoTargetDto.NO_TARGET_DTO;
        }
        return this.environmentApi.getTarget(environmentName, targetName);
    }

    private List<NamedHostAndPort> getAgents(TargetDto targetDto, String env) {
        List<Object> nhaps = Collections.emptyList();
        Optional networkDescription = this.currentNetworkDescription.findCurrent();
        if (networkDescription.isPresent() && ((NetworkDescription)networkDescription.get()).localAgent().isPresent()) {
            Agent localAgent = (Agent)((NetworkDescription)networkDescription.get()).localAgent().get();
            List agents = localAgent.findFellowAgentForReaching(targetDto.name, env);
            nhaps = agents.stream().map(a -> a.agentInfo).collect(Collectors.toList());
        }
        return nhaps;
    }
}

