/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.component.dataset.infra;

import com.chutneytesting.component.ComposableIdUtils;
import com.chutneytesting.component.dataset.infra.OrientDataSetMapper;
import com.chutneytesting.component.scenario.infra.orient.OrientComponentDB;
import com.chutneytesting.component.scenario.infra.orient.OrientUtils;
import com.chutneytesting.dataset.domain.DataSetRepository;
import com.chutneytesting.server.core.domain.dataset.DataSet;
import com.chutneytesting.server.core.domain.dataset.DataSetNotFoundException;
import com.google.common.collect.Lists;
import com.orientechnologies.orient.core.db.ODatabasePool;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Repository;

@Primary
@Repository
public class OrientDataSetRepository
implements DataSetRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrientDataSetRepository.class);
    private final ODatabasePool componentDBPool;
    private static final String QUERY_SELECT_ALL = "SELECT @rid FROM DataSet";

    public OrientDataSetRepository(OrientComponentDB orientComponentDB) {
        this.componentDBPool = orientComponentDB.dbPool();
    }

    public String save(DataSet dataSet) {
        ODatabaseSession dbSession = null;
        try {
            dbSession = this.componentDBPool.acquire();
            dbSession.begin();
            OElement savedDataSet = this.save(dataSet, dbSession);
            dbSession.commit();
            LOGGER.info("Save dataset : " + savedDataSet.toString());
            String string = ComposableIdUtils.toExternalId(savedDataSet.getIdentity().toString(null).toString());
            return string;
        }
        catch (Exception e) {
            OrientUtils.rollback(dbSession);
            throw new RuntimeException(e);
        }
        finally {
            OrientUtils.close(dbSession);
        }
    }

    public DataSet findById(String dataSetId) {
        String internalId = ComposableIdUtils.toInternalId(dataSetId);
        try (ODatabaseSession dbSession = this.componentDBPool.acquire();){
            OElement element = OrientUtils.load(internalId, dbSession).orElseThrow(() -> new DataSetNotFoundException(internalId));
            DataSet dataSet = OrientDataSetMapper.elementToDataSet(element);
            return dataSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet removeById(String dataSetId) {
        String internalId = ComposableIdUtils.toInternalId(dataSetId);
        ODatabaseSession dbSession = null;
        try {
            dbSession = this.componentDBPool.acquire();
            dbSession.begin();
            OElement removedODataSet = (OElement)OrientUtils.load(internalId, dbSession).orElseThrow(() -> new DataSetNotFoundException(internalId)).delete();
            DataSet removedDataSet = OrientDataSetMapper.elementToDataSet(removedODataSet);
            dbSession.commit();
            LOGGER.info("Delete dataset : " + internalId);
            DataSet dataSet = removedDataSet;
            return dataSet;
        }
        finally {
            OrientUtils.close(dbSession);
        }
    }

    public List<DataSet> findAll() {
        try (ODatabaseSession dbSession = this.componentDBPool.acquire();){
            OResultSet datasets = dbSession.query(QUERY_SELECT_ALL, new Object[0]);
            List<DataSet> list = Lists.newArrayList((Iterator)datasets).stream().map(rs -> {
                OElement element = (OElement)dbSession.load((ORID)new ORecordId(rs.getProperty("@rid").toString()));
                return OrientDataSetMapper.elementToDataSetMetaData(element);
            }).collect(Collectors.toList());
            return list;
        }
    }

    private OElement save(DataSet dataSet, ODatabaseSession dbSession) {
        String internalId = ComposableIdUtils.toInternalId(dataSet.id);
        Optional<OElement> dataSetRecord = OrientUtils.load(internalId, dbSession);
        OElement oDataSet = dataSetRecord.orElse((OElement)dbSession.newInstance("DataSet"));
        OrientDataSetMapper.dataSetToElement(dataSet, oDataSet);
        return (OElement)oDataSet.save();
    }
}

