/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.component.scenario.infra.wrapper;

import com.chutneytesting.component.scenario.infra.wrapper.StepVertex;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OVertex;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepRelation {
    private static final Logger LOGGER = LoggerFactory.getLogger(StepRelation.class);
    private final OEdge relation;

    public StepRelation(OEdge relation) {
        this.relation = relation;
    }

    public OVertex getParentVertex() {
        return this.relation.getFrom();
    }

    public StepVertex getParentStep() {
        return StepVertex.builder().from(this.getParentVertex()).build();
    }

    public OVertex getChildVertex() {
        return this.relation.getTo();
    }

    public StepVertex getChildStep() {
        Map executionParameters = (Map)this.relation.getProperty("parameters");
        return StepVertex.builder().from(this.getChildVertex()).withExecutionParameters(executionParameters).build();
    }

    public Map<String, String> executionParameters() {
        return (Map)this.relation.getProperty("parameters");
    }

    public void setExecutionParameters(Map<String, String> executionParameters) {
        this.relation.setProperty("parameters", executionParameters);
    }

    public boolean isValid() {
        boolean isValid = Optional.ofNullable(this.getChildVertex()).isPresent();
        if (!isValid) {
            LOGGER.warn("Ignoring edge {} with no child vertex", (Object)this.relation);
        }
        return isValid;
    }

    public void save() {
        this.relation.save();
    }

    public void updateExecutionParameters(Map<String, String> defaultParameters) {
        Map<String, String> executionParameters = this.executionParameters();
        if (executionParameters != null) {
            HashMap newExecutionParameters = new HashMap();
            defaultParameters.forEach((paramKey, paramValue) -> newExecutionParameters.put(paramKey, executionParameters.getOrDefault(paramKey, (String)paramValue)));
            this.relation.setProperty("parameters", newExecutionParameters);
        }
    }
}

