/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.component.scenario.infra.orient;

import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OrientUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrientUtils.class);

    public static void setOrRemoveProperty(OElement element, String name, Optional<?> value, OType type) {
        OrientUtils.setOrRemoveProperty(element, name, value, Optional::isPresent, Optional::get, type);
    }

    public static <T> void setOrRemoveProperty(OElement element, String name, T value, Function<T, Boolean> setCondition, OType type) {
        OrientUtils.setOrRemoveProperty(element, name, value, setCondition, t -> t, type);
    }

    public static <T> void setOrRemoveProperty(OElement element, String name, T value, Function<T, Boolean> setCondition, Function<T, Object> extractValueFunction, OType type) {
        if (setCondition.apply(value).booleanValue()) {
            element.setProperty(name, extractValueFunction.apply(value), new OType[]{type});
        } else {
            element.removeProperty(name);
        }
    }

    public static void setOrRemoveProperty(OElement element, String name, String value, OType type) {
        OrientUtils.setOrRemoveProperty(element, name, value, StringUtils::isNotBlank, type);
    }

    public static void setOrRemoveProperty(OElement element, String name, Object value, OType type) {
        OrientUtils.setOrRemoveProperty(element, name, value, Objects::nonNull, type);
    }

    public static void setOnlyOnceProperty(OElement element, String name, Object value, OType type) {
        if (element.getProperty(name) == null) {
            element.setProperty(name, value, new OType[]{type});
        }
    }

    public static Long resultSetToCount(OResultSet resultSet) {
        OResult result;
        if (resultSet.hasNext() && (result = resultSet.next()).hasProperty("count")) {
            return (Long)result.getProperty("count");
        }
        throw new IllegalArgumentException("OResultSet has no count property");
    }

    public static String addPaginationParameters(String query) {
        return query + " SKIP ? LIMIT ?";
    }

    public static OClass createClass(String className, String superClassName, int clusterNb, ODatabaseSession dbSession) {
        if (clusterNb > 0) {
            if (superClassName != null) {
                OResultSet ignored = dbSession.command("CREATE CLASS " + className + " EXTENDS " + superClassName + " CLUSTERS " + clusterNb, new Object[0]);
                if (ignored != null) {
                    ignored.close();
                }
            } else {
                OResultSet ignored = dbSession.command("CREATE CLASS " + className + " CLUSTERS " + clusterNb, new Object[0]);
                if (ignored != null) {
                    ignored.close();
                }
            }
            return dbSession.getClass(className);
        }
        if (superClassName != null) {
            return dbSession.createClass(className, new String[]{superClassName});
        }
        return dbSession.createClass(className, new String[0]);
    }

    public static void dropClassWithData(String className, ODatabaseSession dbSession) {
        OClass oClass = dbSession.getClass(className);
        if (oClass != null) {
            oClass.getIndexes().forEach(index -> OrientUtils.dropdIndex(index.getName(), dbSession));
            IntStream.of(oClass.getClusterIds()).filter(clusterId -> oClass.getDefaultClusterId() != clusterId).forEach(clusterId -> {
                oClass.removeClusterId(clusterId);
                dbSession.dropCluster(clusterId);
            });
            OrientUtils.dropClass(className, dbSession);
        } else {
            LOGGER.warn("Cannot find {} class : skip dropping ", (Object)className);
        }
    }

    public static OClass createClass(String className, int clusterNb, ODatabaseSession dbSession) {
        return OrientUtils.createClass(className, null, clusterNb, dbSession);
    }

    static void rebuildIndex(String indexName, ODatabaseSession dbSession) {
        try (OResultSet rs = dbSession.command("REBUILD INDEX " + indexName, new Object[0]);){
            OResult result;
            if (rs.hasNext() && (result = rs.next()).hasProperty("totalIndexed")) {
                LOGGER.debug("Rebuild index : {} indexed {} documents", (Object)indexName, result.getProperty("totalIndexed"));
            }
        }
    }

    public static void close(ODatabaseSession dbSession) {
        if (dbSession != null) {
            dbSession.close();
        }
    }

    public static void rollback(ODatabaseSession dbSession) {
        if (dbSession != null) {
            dbSession.rollback();
        }
    }

    public static Optional<OElement> load(String recordId, ODatabaseSession dbSession) {
        if (!recordId.isEmpty() && ORecordId.isA((String)recordId)) {
            try {
                return Optional.ofNullable((OElement)dbSession.load((ORID)new ORecordId(recordId)));
            }
            catch (ORecordNotFoundException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public static void reloadIfDirty(OElement element) {
        if (element.isDirty()) {
            element.reload();
        }
    }

    public static void deleteVertex(String recordId, ODatabaseSession dbSession) {
        if (!recordId.isEmpty() && ORecordId.isA((String)recordId)) {
            OResultSet ignored = dbSession.command("DELETE VERTEX " + recordId, new Object[0]);
            if (ignored != null) {
                ignored.close();
            }
        } else {
            LOGGER.warn("Cannot delete vertex with wrong id : {}", (Object)recordId);
        }
    }

    public static void dropdIndex(String indexName, ODatabaseSession dbSession) {
        OResultSet ignored = dbSession.command("DROP INDEX " + indexName + " IF EXISTS", new Object[0]);
        if (ignored != null) {
            ignored.close();
        }
    }

    public static void createProperty(String className, ODatabaseSession dbSession, String propertyName, OType type) {
        OClass aClass = dbSession.getClass(className);
        aClass.createProperty(propertyName, type);
    }

    public static void createIndex(String className, ODatabaseSession dbSession, String indexName, OClass.INDEX_TYPE indexType, String ... propertiesToIndex) {
        OClass aClass = dbSession.getClass(className);
        aClass.createIndex(indexName, indexType.name(), null, null, "LUCENE", propertiesToIndex);
    }

    private static void dropClass(String className, ODatabaseSession dbSession) {
        OResultSet ignored = dbSession.command("DROP CLASS " + className, new Object[0]);
        if (ignored != null) {
            ignored.close();
        }
    }
}

