/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.component.scenario.infra;

import com.chutneytesting.component.ComposableIdUtils;
import com.chutneytesting.component.scenario.domain.ComposableTestCase;
import com.chutneytesting.component.scenario.infra.ExecutableComposedTestCaseMapper;
import com.chutneytesting.component.scenario.infra.OrientComposableTestCaseMapper;
import com.chutneytesting.component.scenario.infra.orient.OrientComponentDB;
import com.chutneytesting.component.scenario.infra.orient.OrientUtils;
import com.chutneytesting.component.scenario.infra.wrapper.TestCaseVertex;
import com.chutneytesting.server.core.domain.scenario.AggregatedRepository;
import com.chutneytesting.server.core.domain.scenario.AlreadyExistingScenarioException;
import com.chutneytesting.server.core.domain.scenario.ScenarioNotFoundException;
import com.chutneytesting.server.core.domain.scenario.TestCase;
import com.chutneytesting.server.core.domain.scenario.TestCaseMetadata;
import com.google.common.collect.Lists;
import com.orientechnologies.orient.core.db.ODatabasePool;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class OrientComposableTestCaseRepository
implements AggregatedRepository<ComposableTestCase> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrientComposableTestCaseRepository.class);
    private final ODatabasePool componentDBPool;
    private final ExecutableComposedTestCaseMapper testCaseMapper;
    private static final String QUERY_SELECT_ALL = "SELECT @rid FROM TestCase";

    public OrientComposableTestCaseRepository(OrientComponentDB orientComponentDB, ExecutableComposedTestCaseMapper testCaseMapper) {
        this.componentDBPool = orientComponentDB.dbPool();
        this.testCaseMapper = testCaseMapper;
    }

    public String save(ComposableTestCase composableTestCase) {
        ODatabaseSession dbSession = null;
        OVertex savedFStep = null;
        try {
            dbSession = this.componentDBPool.acquire();
            dbSession.begin();
            savedFStep = this.save(composableTestCase, dbSession);
            dbSession.commit();
            LOGGER.debug("Save scenario :" + savedFStep.toString());
            String string = ComposableIdUtils.toExternalId(savedFStep.getIdentity().toString());
            return string;
        }
        catch (ORecordDuplicatedException e) {
            OrientUtils.rollback(dbSession);
            throw new AlreadyExistingScenarioException(e.getMessage());
        }
        catch (OConcurrentModificationException e) {
            OrientUtils.rollback(dbSession);
            throw new ScenarioNotFoundException(composableTestCase.id, Integer.valueOf(savedFStep.getVersion()));
        }
        catch (ScenarioNotFoundException e) {
            OrientUtils.rollback(dbSession);
            throw e;
        }
        catch (Exception e) {
            OrientUtils.rollback(dbSession);
            throw new RuntimeException(e);
        }
        finally {
            OrientUtils.close(dbSession);
        }
    }

    public Optional<ComposableTestCase> findById(String composableTestCaseId) {
        String internalId = ComposableIdUtils.toInternalId(composableTestCaseId);
        try (ODatabaseSession dbSession = this.componentDBPool.acquire();){
            OVertex element = (OVertex)OrientUtils.load(internalId, dbSession).orElseThrow(() -> new ScenarioNotFoundException(internalId));
            Optional<ComposableTestCase> optional = Optional.ofNullable(OrientComposableTestCaseMapper.vertexToTestCase(TestCaseVertex.builder().from(element).build()));
            return optional;
        }
    }

    public Optional<TestCaseMetadata> findMetadataById(String testCaseId) {
        return this.findById(testCaseId).map(tc -> tc.metadata);
    }

    public Optional<TestCase> findExecutableById(String composableTestCaseId) {
        String internalId = ComposableIdUtils.toInternalId(composableTestCaseId);
        Optional<ComposableTestCase> composableTestCase = this.findById(internalId);
        return composableTestCase.map(ctc -> this.testCaseMapper.composableToExecutable((ComposableTestCase)ctc));
    }

    public List<TestCaseMetadata> findAll() {
        try (ODatabaseSession dbSession = this.componentDBPool.acquire();){
            OResultSet allSteps = dbSession.query(QUERY_SELECT_ALL, new Object[0]);
            List<TestCaseMetadata> list = Lists.newArrayList((Iterator)allSteps).stream().map(rs -> {
                OVertex element = (OVertex)dbSession.load((ORID)new ORecordId(rs.getProperty("@rid").toString()));
                return OrientComposableTestCaseMapper.vertexToTestCase((TestCaseVertex)TestCaseVertex.builder().from((OVertex)element).build()).metadata;
            }).collect(Collectors.toList());
            return list;
        }
    }

    public void removeById(String testCaseId) {
        String internalId = ComposableIdUtils.toInternalId(testCaseId);
        try (ODatabaseSession dbSession = this.componentDBPool.acquire();){
            OrientUtils.deleteVertex(internalId, dbSession);
        }
    }

    public Optional<Integer> lastVersion(String composableTestCaseId) {
        String internalId = ComposableIdUtils.toInternalId(composableTestCaseId);
        try (ODatabaseSession dbSession = this.componentDBPool.acquire();){
            OVertex element = (OVertex)OrientUtils.load(internalId, dbSession).orElseThrow(() -> new ScenarioNotFoundException(internalId));
            Optional<Integer> optional = Optional.of(element.getVersion());
            return optional;
        }
    }

    public List<TestCaseMetadata> search(String textFilter) {
        String[] words = StringEscapeUtils.escapeSql((String)textFilter).split("\\s");
        String fullTextSearch = Arrays.stream(words).map(w -> "+" + w + "*").collect(Collectors.joining(" "));
        String query = "SELECT @rid FROM TestCase WHERE SEARCH_CLASS(\"" + fullTextSearch + "\") = true";
        try (ODatabaseSession dbSession = this.componentDBPool.acquire();){
            OResultSet allSteps = dbSession.query(query, new Object[0]);
            List<TestCaseMetadata> list = Lists.newArrayList((Iterator)allSteps).stream().map(rs -> {
                OVertex element = (OVertex)dbSession.load((ORID)new ORecordId(rs.getProperty("@rid").toString()));
                return OrientComposableTestCaseMapper.vertexToTestCase((TestCaseVertex)TestCaseVertex.builder().from((OVertex)element).build()).metadata;
            }).collect(Collectors.toList());
            return list;
        }
    }

    private OVertex save(ComposableTestCase composableTestCase, ODatabaseSession dbSession) {
        String internalId = ComposableIdUtils.toInternalId(composableTestCase.id);
        Optional<OElement> stepRecord = OrientUtils.load(internalId, dbSession);
        if (stepRecord.isPresent() && stepRecord.get().getVersion() != composableTestCase.metadata.version().intValue()) {
            throw new ScenarioNotFoundException(internalId, composableTestCase.metadata.version());
        }
        OVertex testCase = (OVertex)stepRecord.orElseGet(() -> dbSession.newVertex("TestCase"));
        TestCaseVertex testCaseVertex = OrientComposableTestCaseMapper.testCaseToVertex(composableTestCase, testCase);
        return testCaseVertex.save(dbSession);
    }
}

