/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.component.scenario.api;

import com.chutneytesting.component.scenario.api.ComposableStepMapper;
import com.chutneytesting.component.scenario.api.dto.ComposableStepDto;
import com.chutneytesting.component.scenario.api.dto.ComposableTestCaseDto;
import com.chutneytesting.component.scenario.api.dto.ImmutableComposableScenarioDto;
import com.chutneytesting.component.scenario.api.dto.ImmutableComposableTestCaseDto;
import com.chutneytesting.component.scenario.domain.ComposableScenario;
import com.chutneytesting.component.scenario.domain.ComposableTestCase;
import com.chutneytesting.server.core.domain.scenario.TestCaseMetadata;
import com.chutneytesting.server.core.domain.scenario.TestCaseMetadataImpl;
import com.chutneytesting.server.core.domain.tools.ui.KeyValue;
import java.util.List;
import java.util.stream.Collectors;

public class ComposableTestCaseMapper {
    private ComposableTestCaseMapper() {
    }

    public static ComposableTestCase fromDto(ComposableTestCaseDto composableTestCaseDto) {
        return new ComposableTestCase(composableTestCaseDto.id().orElse(""), ComposableTestCaseMapper.testCaseMetadataFromDto(composableTestCaseDto), ComposableTestCaseMapper.fromComposableStepsDto(composableTestCaseDto));
    }

    public static ComposableTestCaseDto toDto(ComposableTestCase composableTestCase) {
        return ImmutableComposableTestCaseDto.builder().id(composableTestCase.id).title(composableTestCase.metadata.title()).description(composableTestCase.metadata.description()).creationDate(composableTestCase.metadata.creationDate()).executionParameters(KeyValue.fromMap(composableTestCase.executionParameters)).scenario(ImmutableComposableScenarioDto.builder().addAllComponentSteps(ComposableTestCaseMapper.toComposableStepsDto(composableTestCase)).addAllParameters(KeyValue.fromMap(composableTestCase.composableScenario.parameters)).build()).tags(composableTestCase.metadata.tags()).datasetId(composableTestCase.metadata.datasetId().orElse("")).author(composableTestCase.metadata.author()).updateDate(composableTestCase.metadata.updateDate()).version(composableTestCase.metadata.version()).build();
    }

    private static TestCaseMetadata testCaseMetadataFromDto(ComposableTestCaseDto composableTestCaseDto) {
        return TestCaseMetadataImpl.builder().withTitle(composableTestCaseDto.title()).withDescription(composableTestCaseDto.description().orElse("")).withCreationDate(composableTestCaseDto.creationDate()).withTags(composableTestCaseDto.tags()).withDatasetId(composableTestCaseDto.datasetId().orElse("")).withAuthor(composableTestCaseDto.author()).withUpdateDate(composableTestCaseDto.updateDate()).withVersion(composableTestCaseDto.version()).build();
    }

    private static ComposableScenario fromComposableStepsDto(ComposableTestCaseDto composableTestCaseDto) {
        return ComposableScenario.builder().withComposableSteps(composableTestCaseDto.scenario().componentSteps().stream().map(ComposableStepMapper::fromDto).collect(Collectors.toList())).withParameters(KeyValue.toMap(composableTestCaseDto.scenario().parameters())).build();
    }

    private static List<ComposableStepDto> toComposableStepsDto(ComposableTestCase composableTestCase) {
        return composableTestCase.composableScenario.composableSteps.stream().map(ComposableStepMapper::toDto).collect(Collectors.toList());
    }
}

