/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.component.dataset.infra;

import com.chutneytesting.component.ComposableIdUtils;
import com.chutneytesting.server.core.domain.dataset.DataSet;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.OElement;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;
import java.util.Map;

class OrientDataSetMapper {
    OrientDataSetMapper() {
    }

    protected static void dataSetToElement(DataSet dataSet, OElement oDataSet) {
        OrientDataSetMapper.dataSetMetaDataToElement(dataSet, oDataSet);
        oDataSet.setProperty("uniqueValues", (Object)dataSet.constants, new OType[]{OType.EMBEDDEDMAP});
        oDataSet.setProperty("multipleValues", (Object)dataSet.datatable, new OType[]{OType.EMBEDDEDLIST});
    }

    private static void dataSetMetaDataToElement(DataSet dataSet, OElement oDataSet) {
        oDataSet.setProperty("name", (Object)dataSet.name, new OType[]{OType.STRING});
        oDataSet.setProperty("description", (Object)dataSet.description, new OType[]{OType.STRING});
        oDataSet.setProperty("created", (Object)java.sql.Date.from(dataSet.creationDate), new OType[]{OType.DATETIME});
        oDataSet.setProperty("tags", (Object)dataSet.tags, new OType[]{OType.EMBEDDEDLIST});
    }

    protected static DataSet elementToDataSet(OElement oDataSet) {
        DataSet.DataSetBuilder builder = OrientDataSetMapper.elementToDataSetMetaDataBuilder(oDataSet);
        builder.withConstants((Map)oDataSet.getProperty("uniqueValues")).withDatatable((List)oDataSet.getProperty("multipleValues"));
        return builder.build();
    }

    protected static DataSet elementToDataSetMetaData(OElement oDataSet) {
        return OrientDataSetMapper.elementToDataSetMetaDataBuilder(oDataSet).build();
    }

    protected static DataSet.DataSetBuilder elementToDataSetMetaDataBuilder(OElement oDataSet) {
        String internalId = oDataSet.getIdentity().toString();
        String externalId = ComposableIdUtils.toExternalId(internalId);
        return DataSet.builder().withId(externalId).withName((String)oDataSet.getProperty("name")).withDescription((String)oDataSet.getProperty("description")).withCreationDate(((Date)oDataSet.getProperty("created")).toInstant().truncatedTo(ChronoUnit.MILLIS)).withTags((List)oDataSet.getProperty("tags"));
    }
}

