/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.component.dataset.api;

import com.chutneytesting.component.dataset.api.DataSetDto;
import com.chutneytesting.component.dataset.api.DataSetMapper;
import com.chutneytesting.component.dataset.domain.DataSetRepository;
import com.chutneytesting.server.core.domain.dataset.DataSet;
import com.chutneytesting.server.core.domain.dataset.DataSetHistoryRepository;
import com.chutneytesting.server.core.domain.dataset.DataSetNotFoundException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/datasets"})
@CrossOrigin(origins={"*"})
public class DataSetController {
    public static final String BASE_URL = "/api/v1/datasets";
    private final DataSetRepository dataSetRepository;
    private final DataSetHistoryRepository dataSetHistoryRepository;

    public DataSetController(DataSetRepository dataSetRepository, DataSetHistoryRepository dataSetHistoryRepository) {
        this.dataSetRepository = dataSetRepository;
        this.dataSetHistoryRepository = dataSetHistoryRepository;
    }

    @PreAuthorize(value="hasAuthority('DATASET_READ') or hasAuthority('SCENARIO_WRITE') or hasAuthority('CAMPAIGN_WRITE')")
    @GetMapping(path={""}, produces={"application/json"})
    public List<DataSetDto> findAll() {
        return this.dataSetRepository.findAll().stream().map(ds -> DataSetMapper.toDto(ds, this.lastVersionNumber(ds.id))).sorted(DataSetDto.dataSetComparator).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasAuthority('DATASET_WRITE')")
    @PostMapping(path={""}, produces={"application/json"})
    public DataSetDto save(@RequestBody DataSetDto dataSetDto) {
        DataSet newDataSet = DataSetMapper.fromDto(dataSetDto);
        String newDataSetId = this.dataSetRepository.save(newDataSet);
        newDataSet = DataSet.builder().fromDataSet(newDataSet).withId(newDataSetId).build();
        Optional savedVersion = this.dataSetHistoryRepository.addVersion(newDataSet);
        return DataSetMapper.toDto(newDataSet, savedVersion.map(Pair::getRight).orElseGet(() -> this.lastVersionNumber(newDataSetId)));
    }

    @PreAuthorize(value="hasAuthority('DATASET_WRITE')")
    @PutMapping(path={""}, produces={"application/json"})
    public DataSetDto update(@RequestBody DataSetDto dataSetDto) {
        DataSet dataSetToUpdate = DataSetMapper.fromDto(dataSetDto);
        return Optional.ofNullable(dataSetToUpdate.id).map(id -> {
            Optional savedVersion = this.dataSetHistoryRepository.addVersion(dataSetToUpdate);
            if (savedVersion.isPresent()) {
                this.dataSetRepository.save(dataSetToUpdate);
                return DataSetMapper.toDto(dataSetToUpdate, (Integer)((Pair)savedVersion.get()).getRight());
            }
            return this.findById((String)id);
        }).orElseThrow(() -> new DataSetNotFoundException(null));
    }

    @PreAuthorize(value="hasAuthority('DATASET_WRITE')")
    @DeleteMapping(path={"/{dataSetId}"})
    public void deleteById(@PathVariable String dataSetId) {
        this.dataSetRepository.removeById(dataSetId);
        this.dataSetHistoryRepository.removeHistory(dataSetId);
    }

    @PreAuthorize(value="hasAuthority('DATASET_READ')")
    @GetMapping(path={"/{dataSetId}"}, produces={"application/json"})
    public DataSetDto findById(@PathVariable String dataSetId) {
        return DataSetMapper.toDto(this.dataSetRepository.findById(dataSetId), this.lastVersionNumber(dataSetId));
    }

    @PreAuthorize(value="hasAuthority('DATASET_READ')")
    @GetMapping(path={"/{dataSetId}/versions/last"}, produces={"application/json"})
    public Integer lastVersionNumber(@PathVariable String dataSetId) {
        return this.dataSetHistoryRepository.lastVersion(dataSetId);
    }

    @PreAuthorize(value="hasAuthority('DATASET_READ')")
    @GetMapping(path={"/{dataSetId}/versions"}, produces={"application/json"})
    public List<DataSetDto> allVersionNumbers(@PathVariable String dataSetId) {
        return this.dataSetHistoryRepository.allVersions(dataSetId).entrySet().stream().map(e -> DataSetMapper.toDto((DataSet)e.getValue(), (Integer)e.getKey())).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasAuthority('DATASET_READ')")
    @GetMapping(path={"/{dataSetId}/{version}", "/{dataSetId}/versions/{version}"}, produces={"application/json"})
    public DataSetDto version(@PathVariable String dataSetId, @PathVariable Integer version) {
        return DataSetMapper.toDto(this.dataSetHistoryRepository.version(dataSetId, version), version);
    }
}

