/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.component.scenario.infra.wrapper;

import com.chutneytesting.component.scenario.domain.ComposableStep;
import com.chutneytesting.component.scenario.domain.ComposableStepNotFoundException;
import com.chutneytesting.component.scenario.domain.Strategy;
import com.chutneytesting.component.scenario.infra.orient.OrientUtils;
import com.chutneytesting.component.scenario.infra.wrapper.StepRelation;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.OVertex;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class StepVertex {
    private final OVertex vertex;
    private final List<ComposableStep> steps;
    private final Map<String, String> defaultParameters;
    private final Map<String, String> overrideExecutionParameters;

    private StepVertex(OVertex vertex, List<ComposableStep> steps, Map<String, String> defaultParameters, Map<String, String> overrideExecutionParameters) {
        this.vertex = vertex;
        this.steps = steps;
        this.defaultParameters = defaultParameters;
        this.overrideExecutionParameters = overrideExecutionParameters;
    }

    public void reloadIfDirty() {
        OrientUtils.reloadIfDirty((OElement)this.vertex);
    }

    public OVertex save(ODatabaseSession dbSession) {
        this.saveParentEdges();
        this.saveChildrenEdges(dbSession);
        return (OVertex)this.vertex.save();
    }

    private void saveParentEdges() {
        Optional.ofNullable(this.defaultParameters).ifPresent(p -> this.updateExecutionParametersWithParents());
        this.listParentEdges().forEach(StepRelation::save);
    }

    private void updateExecutionParametersWithParents() {
        this.listParentEdges().forEach(relation -> relation.updateExecutionParameters(this.defaultParameters));
    }

    private void saveChildrenEdges(ODatabaseSession dbSession) {
        Optional.ofNullable(this.steps).ifPresent(s -> this.updateSubStepReferences((List<ComposableStep>)s, dbSession));
        this.listChildrenEdges().forEach(StepRelation::save);
    }

    private void updateSubStepReferences(List<ComposableStep> subSteps, ODatabaseSession dbSession) {
        this.removeAllSubStepReferences();
        List vertices = subSteps.stream().map(subStep -> StepVertex.builder().withId(subStep.id).usingSession(dbSession).withExecutionParameters(subStep.executionParameters).build()).collect(Collectors.toList());
        vertices.stream().forEach(v -> this.vertex.addEdge(v.vertex, "Denote").setProperty("parameters", v.executionParameters()));
    }

    private void removeAllSubStepReferences() {
        this.getChildrenEdges().forEach(ORecord::delete);
    }

    public List<OVertex> listParentVertices() {
        return StreamSupport.stream(this.vertex.getVertices(ODirection.IN, new String[]{"Denote"}).spliterator(), false).collect(Collectors.toList());
    }

    public List<OVertex> listChildrenVertices() {
        return StreamSupport.stream(this.vertex.getVertices(ODirection.OUT, new String[]{"Denote"}).spliterator(), false).collect(Collectors.toList());
    }

    public Iterable<OEdge> getParentEdges() {
        return this.vertex.getEdges(ODirection.IN, new String[]{"Denote"});
    }

    public List<StepRelation> listParentEdges() {
        return StreamSupport.stream(this.vertex.getEdges(ODirection.IN, new String[]{"Denote"}).spliterator(), false).map(StepRelation::new).collect(Collectors.toList());
    }

    public Iterable<OEdge> getChildrenEdges() {
        return this.vertex.getEdges(ODirection.OUT, new String[]{"Denote"});
    }

    public List<StepRelation> listChildrenEdges() {
        return StreamSupport.stream(this.vertex.getEdges(ODirection.OUT, new String[]{"Denote"}).spliterator(), false).map(StepRelation::new).collect(Collectors.toList());
    }

    public List<StepRelation> listValidChildrenEdges() {
        return this.listChildrenEdges().stream().filter(StepRelation::isValid).collect(Collectors.toList());
    }

    public List<StepVertex> listChildrenSteps() {
        return this.listValidChildrenEdges().stream().map(StepRelation::getChildStep).collect(Collectors.toList());
    }

    public String id() {
        return this.vertex.getIdentity().toString();
    }

    public String name() {
        return (String)this.vertex.getProperty("name");
    }

    public List<String> tags() {
        return (List)this.vertex.getProperty("tags");
    }

    public String implementation() {
        return (String)this.vertex.getProperty("implementation");
    }

    public Map<String, String> defaultParameters() {
        return (Map)this.vertex.getProperty("parameters");
    }

    public OElement strategy() {
        return (OElement)this.vertex.getProperty("strategy");
    }

    public static StepVertexBuilder builder() {
        return new StepVertexBuilder();
    }

    public Map<String, String> executionParameters() {
        return this.overrideExecutionParameters;
    }

    public static class StepVertexBuilder {
        String id;
        ODatabaseSession dbSession;
        OVertex vertex;
        private String name;
        private Strategy strategy;
        private List<String> tags;
        private Optional<String> implementation = Optional.empty();
        private Map<String, String> defaultParameters;
        private Map<String, String> executionParameters;
        private List<ComposableStep> steps;

        private StepVertexBuilder() {
        }

        public StepVertex build() {
            if (this.vertex == null) {
                this.vertex = (OVertex)OrientUtils.load(this.id, Optional.ofNullable(this.dbSession).orElseThrow(IllegalStateException::new)).orElseThrow(() -> new ComposableStepNotFoundException(this.id));
            }
            Optional.ofNullable(this.name).ifPresent(n -> this.vertex.setProperty("name", n, new OType[]{OType.STRING}));
            this.implementation.ifPresent(i -> OrientUtils.setOrRemoveProperty((OElement)this.vertex, "implementation", i, OType.STRING));
            Optional.ofNullable(this.tags).ifPresent(t -> OrientUtils.setOrRemoveProperty((OElement)this.vertex, "tags", t, OType.EMBEDDEDLIST));
            Optional.ofNullable(this.defaultParameters).ifPresent(p -> this.vertex.setProperty("parameters", p, new OType[]{OType.EMBEDDEDMAP}));
            Optional.ofNullable(this.strategy).ifPresent(s -> Optional.ofNullable(this.dbSession).ifPresent(session -> {
                OElement strategy = this.dbSession.newElement();
                strategy.setProperty("name", (Object)s.type, new OType[]{OType.STRING});
                strategy.setProperty("parameters", s.parameters, new OType[]{OType.EMBEDDEDMAP});
                OrientUtils.setOrRemoveProperty((OElement)this.vertex, "strategy", strategy, OType.EMBEDDED);
            }));
            return new StepVertex(this.vertex, Optional.ofNullable(this.steps).orElse(Collections.emptyList()), Optional.ofNullable(this.defaultParameters).orElse(Collections.emptyMap()), Optional.ofNullable(this.executionParameters).orElse(Collections.emptyMap()));
        }

        public StepVertexBuilder from(OVertex vertex) {
            this.vertex = vertex;
            return this;
        }

        public StepVertexBuilder usingSession(ODatabaseSession dbSession) {
            this.dbSession = dbSession;
            return this;
        }

        public StepVertexBuilder withId(String id) {
            this.id = id;
            return this;
        }

        public StepVertexBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public StepVertexBuilder withTags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        public StepVertexBuilder withImplementation(Optional<String> implementation) {
            this.implementation = implementation;
            return this;
        }

        public StepVertexBuilder withStrategy(Strategy strategy) {
            this.strategy = strategy;
            return this;
        }

        public StepVertexBuilder withDefaultParameters(Map<String, String> defaultParameters) {
            this.defaultParameters = defaultParameters;
            return this;
        }

        public StepVertexBuilder withExecutionParameters(Map<String, String> executionParameters) {
            this.executionParameters = executionParameters;
            return this;
        }

        public StepVertexBuilder withSteps(List<ComposableStep> steps) {
            this.steps = steps;
            return this;
        }
    }
}

