package com.chutneytesting.component.dataset.api;

import com.chutneytesting.server.core.domain.tools.ui.KeyValue;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DataSetDto}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDataSetDto.builder()}.
 */
@Generated(from = "DataSetDto", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDataSetDto implements DataSetDto {
  private final @Nullable String id;
  private final String name;
  private final Integer version;
  private final String description;
  private final Instant lastUpdated;
  private final List<String> tags;
  private final List<KeyValue> constants;
  private final List<List<KeyValue>> datatable;

  private ImmutableDataSetDto(ImmutableDataSetDto.Builder builder) {
    this.id = builder.id;
    this.name = builder.name;
    if (builder.version != null) {
      initShim.version(builder.version);
    }
    if (builder.description != null) {
      initShim.description(builder.description);
    }
    if (builder.lastUpdated != null) {
      initShim.lastUpdated(builder.lastUpdated);
    }
    if (builder.tagsIsSet()) {
      initShim.tags(createUnmodifiableList(true, builder.tags));
    }
    if (builder.constantsIsSet()) {
      initShim.constants(createUnmodifiableList(true, builder.constants));
    }
    if (builder.datatableIsSet()) {
      initShim.datatable(createUnmodifiableList(true, builder.datatable));
    }
    this.version = initShim.version();
    this.description = initShim.description();
    this.lastUpdated = initShim.lastUpdated();
    this.tags = initShim.tags();
    this.constants = initShim.constants();
    this.datatable = initShim.datatable();
    this.initShim = null;
  }

  private ImmutableDataSetDto(
      @Nullable String id,
      String name,
      Integer version,
      String description,
      Instant lastUpdated,
      List<String> tags,
      List<KeyValue> constants,
      List<List<KeyValue>> datatable) {
    this.id = id;
    this.name = name;
    this.version = version;
    this.description = description;
    this.lastUpdated = lastUpdated;
    this.tags = tags;
    this.constants = constants;
    this.datatable = datatable;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "DataSetDto", generator = "Immutables")
  private final class InitShim {
    private byte versionBuildStage = STAGE_UNINITIALIZED;
    private Integer version;

    Integer version() {
      if (versionBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (versionBuildStage == STAGE_UNINITIALIZED) {
        versionBuildStage = STAGE_INITIALIZING;
        this.version = Objects.requireNonNull(versionInitialize(), "version");
        versionBuildStage = STAGE_INITIALIZED;
      }
      return this.version;
    }

    void version(Integer version) {
      this.version = version;
      versionBuildStage = STAGE_INITIALIZED;
    }

    private byte descriptionBuildStage = STAGE_UNINITIALIZED;
    private String description;

    String description() {
      if (descriptionBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (descriptionBuildStage == STAGE_UNINITIALIZED) {
        descriptionBuildStage = STAGE_INITIALIZING;
        this.description = Objects.requireNonNull(descriptionInitialize(), "description");
        descriptionBuildStage = STAGE_INITIALIZED;
      }
      return this.description;
    }

    void description(String description) {
      this.description = description;
      descriptionBuildStage = STAGE_INITIALIZED;
    }

    private byte lastUpdatedBuildStage = STAGE_UNINITIALIZED;
    private Instant lastUpdated;

    Instant lastUpdated() {
      if (lastUpdatedBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (lastUpdatedBuildStage == STAGE_UNINITIALIZED) {
        lastUpdatedBuildStage = STAGE_INITIALIZING;
        this.lastUpdated = Objects.requireNonNull(lastUpdatedInitialize(), "lastUpdated");
        lastUpdatedBuildStage = STAGE_INITIALIZED;
      }
      return this.lastUpdated;
    }

    void lastUpdated(Instant lastUpdated) {
      this.lastUpdated = lastUpdated;
      lastUpdatedBuildStage = STAGE_INITIALIZED;
    }

    private byte tagsBuildStage = STAGE_UNINITIALIZED;
    private List<String> tags;

    List<String> tags() {
      if (tagsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (tagsBuildStage == STAGE_UNINITIALIZED) {
        tagsBuildStage = STAGE_INITIALIZING;
        this.tags = createUnmodifiableList(false, createSafeList(tagsInitialize(), true, false));
        tagsBuildStage = STAGE_INITIALIZED;
      }
      return this.tags;
    }

    void tags(List<String> tags) {
      this.tags = tags;
      tagsBuildStage = STAGE_INITIALIZED;
    }

    private byte constantsBuildStage = STAGE_UNINITIALIZED;
    private List<KeyValue> constants;

    List<KeyValue> constants() {
      if (constantsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (constantsBuildStage == STAGE_UNINITIALIZED) {
        constantsBuildStage = STAGE_INITIALIZING;
        this.constants = createUnmodifiableList(false, createSafeList(constantsInitialize(), true, false));
        constantsBuildStage = STAGE_INITIALIZED;
      }
      return this.constants;
    }

    void constants(List<KeyValue> constants) {
      this.constants = constants;
      constantsBuildStage = STAGE_INITIALIZED;
    }

    private byte datatableBuildStage = STAGE_UNINITIALIZED;
    private List<List<KeyValue>> datatable;

    List<List<KeyValue>> datatable() {
      if (datatableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (datatableBuildStage == STAGE_UNINITIALIZED) {
        datatableBuildStage = STAGE_INITIALIZING;
        this.datatable = createUnmodifiableList(false, createSafeList(datatableInitialize(), true, false));
        datatableBuildStage = STAGE_INITIALIZED;
      }
      return this.datatable;
    }

    void datatable(List<List<KeyValue>> datatable) {
      this.datatable = datatable;
      datatableBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (versionBuildStage == STAGE_INITIALIZING) attributes.add("version");
      if (descriptionBuildStage == STAGE_INITIALIZING) attributes.add("description");
      if (lastUpdatedBuildStage == STAGE_INITIALIZING) attributes.add("lastUpdated");
      if (tagsBuildStage == STAGE_INITIALIZING) attributes.add("tags");
      if (constantsBuildStage == STAGE_INITIALIZING) attributes.add("constants");
      if (datatableBuildStage == STAGE_INITIALIZING) attributes.add("datatable");
      return "Cannot build DataSetDto, attribute initializers form cycle " + attributes;
    }
  }

  private Integer versionInitialize() {
    return DataSetDto.super.version();
  }

  private String descriptionInitialize() {
    return DataSetDto.super.description();
  }

  private Instant lastUpdatedInitialize() {
    return DataSetDto.super.lastUpdated();
  }

  private List<String> tagsInitialize() {
    return DataSetDto.super.tags();
  }

  private List<KeyValue> constantsInitialize() {
    return DataSetDto.super.constants();
  }

  private List<List<KeyValue>> datatableInitialize() {
    return DataSetDto.super.datatable();
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public Optional<String> id() {
    return Optional.ofNullable(id);
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @JsonProperty("version")
  @Override
  public Integer version() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.version()
        : this.version;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public String description() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.description()
        : this.description;
  }

  /**
   * @return The value of the {@code lastUpdated} attribute
   */
  @JsonProperty("lastUpdated")
  @Override
  public Instant lastUpdated() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.lastUpdated()
        : this.lastUpdated;
  }

  /**
   * @return The value of the {@code tags} attribute
   */
  @JsonProperty("tags")
  @Override
  public List<String> tags() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.tags()
        : this.tags;
  }

  /**
   * @return The value of the {@code constants} attribute
   */
  @JsonProperty("uniqueValues")
  @Override
  public List<KeyValue> constants() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.constants()
        : this.constants;
  }

  /**
   * @return The value of the {@code datatable} attribute
   */
  @JsonProperty("multipleValues")
  @Override
  public List<List<KeyValue>> datatable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.datatable()
        : this.datatable;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link DataSetDto#id() id} attribute.
   * @param value The value for id
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDataSetDto withId(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "id");
    if (Objects.equals(this.id, newValue)) return this;
    return new ImmutableDataSetDto(
        newValue,
        this.name,
        this.version,
        this.description,
        this.lastUpdated,
        this.tags,
        this.constants,
        this.datatable);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link DataSetDto#id() id} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for id
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDataSetDto withId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableDataSetDto(
        value,
        this.name,
        this.version,
        this.description,
        this.lastUpdated,
        this.tags,
        this.constants,
        this.datatable);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataSetDto#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataSetDto withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableDataSetDto(
        this.id,
        newValue,
        this.version,
        this.description,
        this.lastUpdated,
        this.tags,
        this.constants,
        this.datatable);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataSetDto#version() version} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataSetDto withVersion(Integer value) {
    Integer newValue = Objects.requireNonNull(value, "version");
    if (this.version.equals(newValue)) return this;
    return new ImmutableDataSetDto(
        this.id,
        this.name,
        newValue,
        this.description,
        this.lastUpdated,
        this.tags,
        this.constants,
        this.datatable);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataSetDto#description() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataSetDto withDescription(String value) {
    String newValue = Objects.requireNonNull(value, "description");
    if (this.description.equals(newValue)) return this;
    return new ImmutableDataSetDto(
        this.id,
        this.name,
        this.version,
        newValue,
        this.lastUpdated,
        this.tags,
        this.constants,
        this.datatable);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataSetDto#lastUpdated() lastUpdated} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for lastUpdated
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataSetDto withLastUpdated(Instant value) {
    if (this.lastUpdated == value) return this;
    Instant newValue = Objects.requireNonNull(value, "lastUpdated");
    return new ImmutableDataSetDto(
        this.id,
        this.name,
        this.version,
        this.description,
        newValue,
        this.tags,
        this.constants,
        this.datatable);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DataSetDto#tags() tags}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDataSetDto withTags(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableDataSetDto(
        this.id,
        this.name,
        this.version,
        this.description,
        this.lastUpdated,
        newValue,
        this.constants,
        this.datatable);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DataSetDto#tags() tags}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of tags elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDataSetDto withTags(Iterable<String> elements) {
    if (this.tags == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableDataSetDto(
        this.id,
        this.name,
        this.version,
        this.description,
        this.lastUpdated,
        newValue,
        this.constants,
        this.datatable);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DataSetDto#constants() constants}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDataSetDto withConstants(KeyValue... elements) {
    List<KeyValue> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableDataSetDto(
        this.id,
        this.name,
        this.version,
        this.description,
        this.lastUpdated,
        this.tags,
        newValue,
        this.datatable);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DataSetDto#constants() constants}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of constants elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDataSetDto withConstants(Iterable<? extends KeyValue> elements) {
    if (this.constants == elements) return this;
    List<KeyValue> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableDataSetDto(
        this.id,
        this.name,
        this.version,
        this.description,
        this.lastUpdated,
        this.tags,
        newValue,
        this.datatable);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DataSetDto#datatable() datatable}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableDataSetDto withDatatable(List<KeyValue>... elements) {
    List<List<KeyValue>> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableDataSetDto(
        this.id,
        this.name,
        this.version,
        this.description,
        this.lastUpdated,
        this.tags,
        this.constants,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DataSetDto#datatable() datatable}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of datatable elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDataSetDto withDatatable(Iterable<? extends List<KeyValue>> elements) {
    if (this.datatable == elements) return this;
    List<List<KeyValue>> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableDataSetDto(
        this.id,
        this.name,
        this.version,
        this.description,
        this.lastUpdated,
        this.tags,
        this.constants,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDataSetDto} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDataSetDto
        && equalTo(0, (ImmutableDataSetDto) another);
  }

  private boolean equalTo(int synthetic, ImmutableDataSetDto another) {
    return Objects.equals(id, another.id)
        && name.equals(another.name)
        && version.equals(another.version)
        && description.equals(another.description)
        && lastUpdated.equals(another.lastUpdated)
        && tags.equals(another.tags)
        && constants.equals(another.constants)
        && datatable.equals(another.datatable);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code version}, {@code description}, {@code lastUpdated}, {@code tags}, {@code constants}, {@code datatable}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + version.hashCode();
    h += (h << 5) + description.hashCode();
    h += (h << 5) + lastUpdated.hashCode();
    h += (h << 5) + tags.hashCode();
    h += (h << 5) + constants.hashCode();
    h += (h << 5) + datatable.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DataSetDto} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("DataSetDto{");
    if (id != null) {
      builder.append("id=").append(id);
    }
    if (builder.length() > 11) builder.append(", ");
    builder.append("name=").append(name);
    builder.append(", ");
    builder.append("version=").append(version);
    builder.append(", ");
    builder.append("description=").append(description);
    builder.append(", ");
    builder.append("lastUpdated=").append(lastUpdated);
    builder.append(", ");
    builder.append("tags=").append(tags);
    builder.append(", ");
    builder.append("constants=").append(constants);
    builder.append(", ");
    builder.append("datatable=").append(datatable);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DataSetDto", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DataSetDto {
    @Nullable Optional<String> id = Optional.empty();
    @Nullable String name;
    @Nullable Integer version;
    @Nullable String description;
    @Nullable Instant lastUpdated;
    @Nullable List<String> tags = Collections.emptyList();
    boolean tagsIsSet;
    @Nullable List<KeyValue> constants = Collections.emptyList();
    boolean constantsIsSet;
    @Nullable List<List<KeyValue>> datatable = Collections.emptyList();
    boolean datatableIsSet;
    @JsonProperty("id")
    public void setId(Optional<String> id) {
      this.id = id;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("version")
    public void setVersion(Integer version) {
      this.version = version;
    }
    @JsonProperty("description")
    public void setDescription(String description) {
      this.description = description;
    }
    @JsonProperty("lastUpdated")
    public void setLastUpdated(Instant lastUpdated) {
      this.lastUpdated = lastUpdated;
    }
    @JsonProperty("tags")
    public void setTags(List<String> tags) {
      this.tags = tags;
      this.tagsIsSet = true;
    }
    @JsonProperty("uniqueValues")
    public void setConstants(List<KeyValue> constants) {
      this.constants = constants;
      this.constantsIsSet = true;
    }
    @JsonProperty("multipleValues")
    public void setDatatable(List<List<KeyValue>> datatable) {
      this.datatable = datatable;
      this.datatableIsSet = true;
    }
    @Override
    public Optional<String> id() { throw new UnsupportedOperationException(); }
    @Override
    public String name() { throw new UnsupportedOperationException(); }
    @Override
    public Integer version() { throw new UnsupportedOperationException(); }
    @Override
    public String description() { throw new UnsupportedOperationException(); }
    @Override
    public Instant lastUpdated() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> tags() { throw new UnsupportedOperationException(); }
    @Override
    public List<KeyValue> constants() { throw new UnsupportedOperationException(); }
    @Override
    public List<List<KeyValue>> datatable() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableDataSetDto fromJson(Json json) {
    ImmutableDataSetDto.Builder builder = ImmutableDataSetDto.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.version != null) {
      builder.version(json.version);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.lastUpdated != null) {
      builder.lastUpdated(json.lastUpdated);
    }
    if (json.tagsIsSet) {
      builder.addAllTags(json.tags);
    }
    if (json.constantsIsSet) {
      builder.addAllConstants(json.constants);
    }
    if (json.datatableIsSet) {
      builder.addAllDatatable(json.datatable);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DataSetDto} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DataSetDto instance
   */
  public static ImmutableDataSetDto copyOf(DataSetDto instance) {
    if (instance instanceof ImmutableDataSetDto) {
      return (ImmutableDataSetDto) instance;
    }
    return ImmutableDataSetDto.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDataSetDto ImmutableDataSetDto}.
   * <pre>
   * ImmutableDataSetDto.builder()
   *    .id(String) // optional {@link DataSetDto#id() id}
   *    .name(String) // required {@link DataSetDto#name() name}
   *    .version(Integer) // optional {@link DataSetDto#version() version}
   *    .description(String) // optional {@link DataSetDto#description() description}
   *    .lastUpdated(java.time.Instant) // optional {@link DataSetDto#lastUpdated() lastUpdated}
   *    .addTags|addAllTags(String) // {@link DataSetDto#tags() tags} elements
   *    .addConstants|addAllConstants(com.chutneytesting.server.core.domain.tools.ui.KeyValue) // {@link DataSetDto#constants() constants} elements
   *    .addDatatable|addAllDatatable(List&amp;lt;com.chutneytesting.server.core.domain.tools.ui.KeyValue&amp;gt;) // {@link DataSetDto#datatable() datatable} elements
   *    .build();
   * </pre>
   * @return A new ImmutableDataSetDto builder
   */
  public static ImmutableDataSetDto.Builder builder() {
    return new ImmutableDataSetDto.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDataSetDto ImmutableDataSetDto}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DataSetDto", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long OPT_BIT_TAGS = 0x1L;
    private static final long OPT_BIT_CONSTANTS = 0x2L;
    private static final long OPT_BIT_DATATABLE = 0x4L;
    private long initBits = 0x1L;
    private long optBits;

    private @Nullable String id;
    private @Nullable String name;
    private @Nullable Integer version;
    private @Nullable String description;
    private @Nullable Instant lastUpdated;
    private List<String> tags = new ArrayList<String>();
    private List<KeyValue> constants = new ArrayList<KeyValue>();
    private List<List<KeyValue>> datatable = new ArrayList<List<KeyValue>>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DataSetDto} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DataSetDto instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<String> idOptional = instance.id();
      if (idOptional.isPresent()) {
        id(idOptional);
      }
      name(instance.name());
      version(instance.version());
      description(instance.description());
      lastUpdated(instance.lastUpdated());
      addAllTags(instance.tags());
      addAllConstants(instance.constants());
      addAllDatatable(instance.datatable());
      return this;
    }

    /**
     * Initializes the optional value {@link DataSetDto#id() id} to id.
     * @param id The value for id
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return this;
    }

    /**
     * Initializes the optional value {@link DataSetDto#id() id} to id.
     * @param id The value for id
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(Optional<String> id) {
      this.id = id.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link DataSetDto#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link DataSetDto#version() version} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DataSetDto#version() version}.</em>
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("version")
    public final Builder version(Integer version) {
      this.version = Objects.requireNonNull(version, "version");
      return this;
    }

    /**
     * Initializes the value for the {@link DataSetDto#description() description} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DataSetDto#description() description}.</em>
     * @param description The value for description 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("description")
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      return this;
    }

    /**
     * Initializes the value for the {@link DataSetDto#lastUpdated() lastUpdated} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DataSetDto#lastUpdated() lastUpdated}.</em>
     * @param lastUpdated The value for lastUpdated 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("lastUpdated")
    public final Builder lastUpdated(Instant lastUpdated) {
      this.lastUpdated = Objects.requireNonNull(lastUpdated, "lastUpdated");
      return this;
    }

    /**
     * Adds one element to {@link DataSetDto#tags() tags} list.
     * @param element A tags element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTags(String element) {
      this.tags.add(Objects.requireNonNull(element, "tags element"));
      optBits |= OPT_BIT_TAGS;
      return this;
    }

    /**
     * Adds elements to {@link DataSetDto#tags() tags} list.
     * @param elements An array of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTags(String... elements) {
      for (String element : elements) {
        this.tags.add(Objects.requireNonNull(element, "tags element"));
      }
      optBits |= OPT_BIT_TAGS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DataSetDto#tags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("tags")
    public final Builder tags(Iterable<String> elements) {
      this.tags.clear();
      return addAllTags(elements);
    }

    /**
     * Adds elements to {@link DataSetDto#tags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllTags(Iterable<String> elements) {
      for (String element : elements) {
        this.tags.add(Objects.requireNonNull(element, "tags element"));
      }
      optBits |= OPT_BIT_TAGS;
      return this;
    }

    /**
     * Adds one element to {@link DataSetDto#constants() constants} list.
     * @param element A constants element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addConstants(KeyValue element) {
      this.constants.add(Objects.requireNonNull(element, "constants element"));
      optBits |= OPT_BIT_CONSTANTS;
      return this;
    }

    /**
     * Adds elements to {@link DataSetDto#constants() constants} list.
     * @param elements An array of constants elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addConstants(KeyValue... elements) {
      for (KeyValue element : elements) {
        this.constants.add(Objects.requireNonNull(element, "constants element"));
      }
      optBits |= OPT_BIT_CONSTANTS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DataSetDto#constants() constants} list.
     * @param elements An iterable of constants elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("uniqueValues")
    public final Builder constants(Iterable<? extends KeyValue> elements) {
      this.constants.clear();
      return addAllConstants(elements);
    }

    /**
     * Adds elements to {@link DataSetDto#constants() constants} list.
     * @param elements An iterable of constants elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllConstants(Iterable<? extends KeyValue> elements) {
      for (KeyValue element : elements) {
        this.constants.add(Objects.requireNonNull(element, "constants element"));
      }
      optBits |= OPT_BIT_CONSTANTS;
      return this;
    }

    /**
     * Adds one element to {@link DataSetDto#datatable() datatable} list.
     * @param element A datatable element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addDatatable(List<KeyValue> element) {
      this.datatable.add(Objects.requireNonNull(element, "datatable element"));
      optBits |= OPT_BIT_DATATABLE;
      return this;
    }

    /**
     * Adds elements to {@link DataSetDto#datatable() datatable} list.
     * @param elements An array of datatable elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder addDatatable(List<KeyValue>... elements) {
      for (List<KeyValue> element : elements) {
        this.datatable.add(Objects.requireNonNull(element, "datatable element"));
      }
      optBits |= OPT_BIT_DATATABLE;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DataSetDto#datatable() datatable} list.
     * @param elements An iterable of datatable elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("multipleValues")
    public final Builder datatable(Iterable<? extends List<KeyValue>> elements) {
      this.datatable.clear();
      return addAllDatatable(elements);
    }

    /**
     * Adds elements to {@link DataSetDto#datatable() datatable} list.
     * @param elements An iterable of datatable elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllDatatable(Iterable<? extends List<KeyValue>> elements) {
      for (List<KeyValue> element : elements) {
        this.datatable.add(Objects.requireNonNull(element, "datatable element"));
      }
      optBits |= OPT_BIT_DATATABLE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDataSetDto ImmutableDataSetDto}.
     * @return An immutable instance of DataSetDto
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDataSetDto build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDataSetDto(this);
    }

    private boolean tagsIsSet() {
      return (optBits & OPT_BIT_TAGS) != 0;
    }

    private boolean constantsIsSet() {
      return (optBits & OPT_BIT_CONSTANTS) != 0;
    }

    private boolean datatableIsSet() {
      return (optBits & OPT_BIT_DATATABLE) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build DataSetDto, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
