/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.component.admin.infra;

import com.chutneytesting.component.scenario.infra.orient.OrientComponentDB;
import com.chutneytesting.component.scenario.infra.orient.OrientUtils;
import com.chutneytesting.server.core.domain.admin.DatabaseAdminService;
import com.chutneytesting.server.core.domain.admin.SqlResult;
import com.chutneytesting.server.core.domain.tools.ImmutablePaginatedDto;
import com.chutneytesting.server.core.domain.tools.PaginatedDto;
import com.chutneytesting.server.core.domain.tools.PaginationRequestWrapperDto;
import com.chutneytesting.server.core.domain.tools.SqlUtils;
import com.orientechnologies.orient.core.db.ODatabasePool;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.exception.OCoreException;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component(value="orientAdminService")
class OrientAdminService
implements DatabaseAdminService {
    private final ODatabasePool componentDBPool;

    OrientAdminService(OrientComponentDB orientComponentDB) {
        this.componentDBPool = orientComponentDB.dbPool();
    }

    public SqlResult execute(String query) {
        String cleanQuery = this.cleanQuery(query);
        boolean isSelect = this.isQuerySelect(query);
        String finalQuery = isSelect ? this.limit(cleanQuery, false) : cleanQuery;
        return this.executeQuery(finalQuery, isSelect, new Integer[0]);
    }

    public PaginatedDto<SqlResult> paginate(PaginationRequestWrapperDto<String> paginationRequestWrapperDto) {
        String query = paginationRequestWrapperDto.wrappedRequest().orElse("select expand(classes) from metadata:schema");
        String cleanQuery = this.cleanQuery(query);
        boolean isSelect = this.isQuerySelect(query);
        long totalCount = 0L;
        if (isSelect) {
            String countQuery = SqlUtils.count((String)cleanQuery);
            try (ODatabaseSession dbSession = this.componentDBPool.acquire();
                 OResultSet rs = dbSession.command(countQuery, new Object[0]);){
                totalCount = OrientUtils.resultSetToCount(rs);
            }
            catch (OCoreException e) {
                SqlResult result = SqlResult.error((String)("Unable to execute statement[" + countQuery + "]: " + e.getMessage()));
                return ImmutablePaginatedDto.builder().totalCount(totalCount).addData((Object)result).build();
            }
        }
        String finalQuery = isSelect ? this.limit(cleanQuery, true) : cleanQuery;
        SqlResult result = this.executeQuery(finalQuery, isSelect, (paginationRequestWrapperDto.pageNumber() - 1) * paginationRequestWrapperDto.elementPerPage(), paginationRequestWrapperDto.elementPerPage());
        return ImmutablePaginatedDto.builder().totalCount(totalCount).addData((Object)result).build();
    }

    private SqlResult executeQuery(String query, boolean isSelect, Integer ... args) {
        SqlResult result;
        block21: {
            try (ODatabaseSession dbSession = this.componentDBPool.acquire();){
                if (isSelect) {
                    try (OResultSet rs = dbSession.command(query, (Object[])args);){
                        result = SqlResult.data((SqlResult.Table)this.resultSetToTable(rs));
                        break block21;
                    }
                }
                try (OResultSet rs = dbSession.command(query, new Object[0]);){
                    result = this.resultSetToSqlResult(rs);
                }
            }
            catch (OCoreException e) {
                result = SqlResult.error((String)("Unable to execute statement[" + query + "]: " + e.getMessage()));
            }
        }
        return result;
    }

    private String limit(String query, boolean paginate) {
        if (query.replaceAll("\\R", " ").matches(".*(?i:limit).*[^)]")) {
            return query;
        }
        if (paginate) {
            return OrientUtils.addPaginationParameters(query);
        }
        return query + " LIMIT 20";
    }

    private boolean isQuerySelect(String query) {
        return query.trim().toUpperCase().startsWith("SELECT");
    }

    private String cleanQuery(String query) {
        if ((query = query.trim()).endsWith(";")) {
            query = query.substring(0, query.length() - 1);
        }
        return query;
    }

    private SqlResult.Table resultSetToTable(OResultSet resultSet) {
        ArrayList properties = new ArrayList();
        ArrayList<SqlResult.Row> rows = new ArrayList<SqlResult.Row>();
        while (resultSet.hasNext()) {
            OResult result = resultSet.next();
            if (properties.size() == 0) {
                properties.addAll(result.getPropertyNames());
            }
            ArrayList<String> values = new ArrayList<String>();
            for (String propertyName : properties) {
                values.add(Optional.ofNullable(result.getProperty(propertyName)).orElse("").toString());
            }
            rows.add(new SqlResult.Row(values));
        }
        return new SqlResult.Table(properties, rows);
    }

    private SqlResult resultSetToSqlResult(OResultSet resultSet) {
        Optional<Object> totalCount = Optional.empty();
        Optional<Object> table = Optional.empty();
        ArrayList properties = new ArrayList();
        ArrayList<SqlResult.Row> rows = new ArrayList<SqlResult.Row>();
        if (resultSet.hasNext()) {
            OResult result = resultSet.next();
            if (result.hasProperty("count")) {
                totalCount = Optional.of(((Long)result.getProperty("count")).intValue());
                properties.addAll(result.getPropertyNames().stream().filter(s -> !s.equalsIgnoreCase("count")).collect(Collectors.toList()));
            } else {
                properties.addAll(result.getPropertyNames());
            }
            ArrayList<String> values = new ArrayList<String>();
            for (String propertyName : properties) {
                values.add(Optional.ofNullable(result.getProperty(propertyName)).orElse("").toString());
            }
            rows.add(new SqlResult.Row(values));
            if (!values.isEmpty()) {
                table = Optional.of(new SqlResult.Table(properties, rows));
            }
        }
        return new SqlResult(totalCount, Optional.empty(), table);
    }
}

