/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.spi.injectable;

import java.net.URI;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Map;
import java.util.Optional;

public interface Target {
    public String name();

    public URI uri();

    public String rawUri();

    public Optional<String> property(String var1);

    default public Map<String, String> prefixedProperties(String prefix) {
        return this.prefixedProperties(prefix, false);
    }

    public Map<String, String> prefixedProperties(String var1, boolean var2);

    default public Optional<Number> numericProperty(String key) {
        return this.property(key).map(k -> {
            try {
                return NumberFormat.getInstance().parse((String)k);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        });
    }

    default public Optional<Boolean> booleanProperty(String key) {
        return this.property(key).map(Boolean::parseBoolean);
    }

    default public Optional<String> user() {
        return this.property("username").or(() -> this.property("user"));
    }

    default public Optional<String> userPassword() {
        return this.property("userPassword").or(() -> this.property("password"));
    }

    default public Optional<String> trustStore() {
        return this.property("trustStore");
    }

    default public Optional<String> trustStorePassword() {
        return this.property("trustStorePassword");
    }

    default public Optional<String> keyStore() {
        return this.property("keyStore");
    }

    default public Optional<String> keyStorePassword() {
        return this.property("keyStorePassword");
    }

    default public Optional<String> keyPassword() {
        return this.property("keyPassword");
    }

    default public Optional<String> privateKey() {
        return this.property("privateKey");
    }

    default public Optional<String> privateKeyPassword() {
        return this.property("privateKeyPassword").or(() -> this.property("privateKeyPassphrase"));
    }

    default public String host() {
        return this.uri().getHost();
    }

    default public int port() {
        return this.uri().getPort();
    }
}

