/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.spi.time;

import com.chutneytesting.action.spi.time.Duration;
import com.chutneytesting.action.spi.time.DurationParser;
import com.chutneytesting.action.spi.time.DurationUnit;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class UntilHourDurationParser
implements DurationParser {
    private static final String UNTIL_HOURS_REGEX = "^until\\s+(?<hours>[0-2]\\d):(?<minutes>[0-5]\\d)$";
    private static final Pattern UNTIL_HOURS_PATTERN = Pattern.compile("^until\\s+(?<hours>[0-2]\\d):(?<minutes>[0-5]\\d)$");
    private final Clock clock;

    UntilHourDurationParser() {
        this(Clock.systemDefaultZone());
    }

    UntilHourDurationParser(Clock clock) {
        this.clock = clock;
    }

    @Override
    public Optional<Duration> parse(String literalDuration) {
        Optional<Duration> parsingResult;
        Matcher matcher = UNTIL_HOURS_PATTERN.matcher(literalDuration.trim().toLowerCase());
        if (matcher.matches()) {
            int hours = Integer.parseInt(matcher.group("hours"));
            int minutes = Integer.parseInt(matcher.group("minutes"));
            LocalDateTime now = LocalDateTime.now(this.clock);
            LocalDateTime targetTime = now.truncatedTo(ChronoUnit.DAYS).plusHours(hours).plusMinutes(minutes);
            if (targetTime.isBefore(now)) {
                targetTime = targetTime.plusDays(1L);
            }
            long durationInMs = java.time.Duration.between(now, targetTime).toMillis();
            parsingResult = Optional.of(new Duration(durationInMs, DurationUnit.MILLIS));
        } else {
            parsingResult = Optional.empty();
        }
        return parsingResult;
    }

    @Override
    public String description() {
        return "Until hour: until <1..24>:<1..60>\nSamples:\n\t until 02:00\n\t until 17:45";
    }
}

