/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.micrometer;

import com.chutneytesting.action.micrometer.MicrometerActionHelper;
import com.chutneytesting.action.spi.Action;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.util.Optional;

public class MicrometerTimerStartAction
implements Action {
    protected static final String OUTPUT_TIMER_SAMPLE = "micrometerTimerSample";
    private final Logger logger;
    private final MeterRegistry registry;

    public MicrometerTimerStartAction(Logger logger, @Input(value="registry") MeterRegistry registry) {
        this.logger = logger;
        this.registry = Optional.ofNullable(registry).orElse((MeterRegistry)Metrics.globalRegistry);
    }

    public ActionExecutionResult execute() {
        try {
            Timer.Sample sample = Timer.start((MeterRegistry)this.registry);
            this.logger.info("Timing sample started");
            return ActionExecutionResult.ok(MicrometerActionHelper.toOutputs(OUTPUT_TIMER_SAMPLE, sample));
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            return ActionExecutionResult.ko();
        }
    }
}

