/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.jakarta;

import com.chutneytesting.action.jakarta.UncheckedJakartaException;
import com.chutneytesting.action.jakarta.consumer.Consumer;
import com.chutneytesting.action.jakarta.consumer.ConsumerFactory;
import com.chutneytesting.action.spi.injectable.Target;
import com.chutneytesting.tools.CloseableResource;
import com.chutneytesting.tools.ThrowingFunction;
import com.chutneytesting.tools.ThrowingSupplier;
import com.chutneytesting.tools.UncheckedException;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.InvalidSelectorException;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.Hashtable;
import java.util.Map;
import java.util.Optional;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JakartaConnectionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(JakartaConnectionFactory.class);

    public CloseableResource<Consumer> createConsumer(Target target, String destination, String timeout) {
        return this.createConsumer(target, destination, timeout, null, null, 0);
    }

    public CloseableResource<Consumer> createConsumer(Target target, String destination, String timeout, String bodySelector, String selector, int browserMaxDepth) {
        ConsumerFactory consumerFactory = new ConsumerFactory(bodySelector, selector, timeout, browserMaxDepth);
        return this.obtainCloseableResource(target, destination, consumerFactory::build);
    }

    public CloseableResource<MessageSender> getMessageProducer(Target target, String destinationName) throws UncheckedJakartaException {
        return this.obtainCloseableResource(target, destinationName, (session, destination) -> {
            MessageProducer messageProducer = session.createProducer(destination);
            return (messageContent, headers) -> {
                TextMessage message = session.createTextMessage(messageContent);
                for (Map.Entry headerEntry : headers.entrySet()) {
                    message.setStringProperty((String)headerEntry.getKey(), (String)headerEntry.getValue());
                }
                messageProducer.send((Message)message);
            };
        });
    }

    private <T> CloseableResource<T> obtainCloseableResource(Target target, String destinationName, JmsThrowingBiFunction<Session, Destination, T> resourceBuilder) throws UncheckedJakartaException {
        Hashtable<String, String> environmentProperties = new Hashtable<String, String>();
        environmentProperties.put("java.naming.provider.url", target.uri().toString());
        environmentProperties.putAll(target.prefixedProperties("java.naming."));
        environmentProperties.putAll(target.prefixedProperties("jndi.", true));
        this.configureSsl(target, environmentProperties);
        String connectionFactoryName = target.property("connectionFactoryName").orElse("ConnectionFactory");
        try {
            this.debugClassLoader();
            InitialContext context = new InitialContext(environmentProperties);
            ConnectionFactory connectionFactory = (ConnectionFactory)context.lookup(connectionFactoryName);
            Connection connection = this.createConnection(connectionFactory, target);
            connection.start();
            Session session = connection.createSession(false, 1);
            Destination destination = (Destination)context.lookup(destinationName);
            return CloseableResource.build(resourceBuilder.apply(session, destination), () -> {
                try {
                    session.close();
                }
                catch (JMSException e) {
                    LOGGER.warn("Unable to close JMS Session: " + e.getMessage());
                }
                try {
                    connection.close();
                }
                catch (JMSException e) {
                    LOGGER.warn("Unable to close JMS Connection: " + e.getMessage());
                }
            });
        }
        catch (InvalidSelectorException e) {
            throw new UncheckedJakartaException("Cannot parse selector " + e.getMessage(), (Exception)((Object)e));
        }
        catch (NameNotFoundException e) {
            throw new UncheckedJakartaException("Cannot find destination " + e.getMessage() + " on jms server " + target.name() + " (" + target.uri().toString() + ")", e);
        }
        catch (JMSException | NamingException e) {
            throw new UncheckedJakartaException("Cannot connect to jms server " + target.name() + " (" + target.uri().toString() + "): " + e.getMessage(), (Exception)e);
        }
    }

    private void debugClassLoader() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        LOGGER.debug("Thread.currentThread().getContextClassLoader(): " + contextClassLoader);
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        LOGGER.debug("ClassLoader.getSystemClassLoader(): " + systemClassLoader);
    }

    private Connection createConnection(ConnectionFactory connectionFactory, Target target) throws JMSException {
        try {
            return (Connection)target.user().map(ThrowingFunction.toUnchecked(user -> connectionFactory.createConnection(user, target.userPassword().orElse("")))).orElseGet(ThrowingSupplier.toUnchecked(() -> ((ConnectionFactory)connectionFactory).createConnection()));
        }
        catch (UncheckedException e) {
            throw (JMSException)e.getCause();
        }
    }

    private void configureSsl(Target target, Map<String, String> environmentProperties) {
        this.putInMapIfPresent("connection.ConnectionFactory.keyStore", target.keyStore(), environmentProperties);
        this.putInMapIfPresent("connection.ConnectionFactory.keyStorePassword", target.keyStorePassword(), environmentProperties);
        this.putInMapIfPresent("connection.ConnectionFactory.keyStoreKeyPassword", target.keyPassword(), environmentProperties);
        this.putInMapIfPresent("connection.ConnectionFactory.trustStore", target.trustStore(), environmentProperties);
        this.putInMapIfPresent("connection.ConnectionFactory.trustStorePassword", target.trustStorePassword(), environmentProperties);
    }

    private void putInMapIfPresent(String key, Optional<String> optionalValue, Map<String, String> map) {
        optionalValue.ifPresent(s -> map.put(key, (String)s));
    }

    private static interface JmsThrowingBiFunction<T1, T2, R> {
        public R apply(T1 var1, T2 var2) throws JMSException;
    }

    public static interface MessageSender {
        public void send(String var1, Map<String, String> var2) throws JMSException;
    }
}

