/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.mongo;

import com.chutneytesting.action.mongo.DefaultMongoDatabaseFactory;
import com.chutneytesting.action.mongo.MongoActionValidatorsUtils;
import com.chutneytesting.action.mongo.MongoDatabaseFactory;
import com.chutneytesting.action.spi.Action;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import com.chutneytesting.action.spi.injectable.Target;
import com.chutneytesting.action.spi.validation.ActionValidatorsUtils;
import com.chutneytesting.action.spi.validation.Validator;
import com.chutneytesting.tools.CloseableResource;
import com.mongodb.client.MongoDatabase;
import java.util.Collections;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;

public class MongoCountAction
implements Action {
    private final MongoDatabaseFactory mongoDatabaseFactory = new DefaultMongoDatabaseFactory();
    private final Target target;
    private final Logger logger;
    private final String collection;
    private final String query;

    public MongoCountAction(Target target, Logger logger, @Input(value="collection") String collection, @Input(value="query") String query) {
        this.target = target;
        this.logger = logger;
        this.collection = collection;
        this.query = query;
    }

    public List<String> validateInputs() {
        return Validator.getErrorsFrom((Validator[])new Validator[]{ActionValidatorsUtils.notBlankStringValidation((String)this.collection, (String)"collection"), ActionValidatorsUtils.notBlankStringValidation((String)this.query, (String)"query"), MongoActionValidatorsUtils.mongoTargetValidation(this.target)});
    }

    public ActionExecutionResult execute() {
        ActionExecutionResult actionExecutionResult;
        block8: {
            CloseableResource<MongoDatabase> database = this.mongoDatabaseFactory.create(this.target);
            try {
                long count = ((MongoDatabase)database.getResource()).getCollection(this.collection).countDocuments((Bson)BsonDocument.parse((String)this.query));
                this.logger.info("Found " + count + " objects matching query:\n\t" + this.query.replace("\n", "\n\t"));
                actionExecutionResult = ActionExecutionResult.ok(Collections.singletonMap("count", count));
                if (database == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (database != null) {
                        try {
                            database.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalArgumentException e) {
                    this.logger.error(e.getMessage());
                    return ActionExecutionResult.ko();
                }
            }
            database.close();
        }
        return actionExecutionResult;
    }
}

