/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.selenium.driver;

import com.chutneytesting.action.selenium.driver.AbstractSeleniumDriverInitAction;
import com.chutneytesting.action.spi.injectable.FinallyActionRegistry;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;

public class SeleniumGenericDriverInitAction
extends AbstractSeleniumDriverInitAction {
    private final ObjectMapper mapper = new ObjectMapper();
    private final String seleniumConfigurationAsJson;

    protected SeleniumGenericDriverInitAction(FinallyActionRegistry finallyActionRegistry, Logger logger, @Input(value="hub") String hubUrl, @Input(value="jsonConfiguration") String seleniumConfigurationAsJson) {
        super(finallyActionRegistry, logger, hubUrl, null, null, null);
        this.seleniumConfigurationAsJson = seleniumConfigurationAsJson;
    }

    @Override
    protected MutableCapabilities buildOptions() {
        Map readFromJson;
        try {
            readFromJson = (Map)this.mapper.readValue(this.seleniumConfigurationAsJson, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Parsing error. Cannot transform json configuration to Selenium capabilities");
        }
        return new MutableCapabilities(readFromJson);
    }

    @Override
    protected WebDriver localWebDriver(Capabilities capabilities) {
        throw new IllegalStateException("Cannot create generic local web driver");
    }

    @Override
    protected Class<?> getChildClass() {
        return SeleniumGenericDriverInitAction.class;
    }
}

