/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.selenium.driver;

import com.chutneytesting.action.selenium.driver.AbstractSeleniumDriverInitAction;
import com.chutneytesting.action.spi.injectable.FinallyActionRegistry;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxDriverLogLevel;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;

public class SeleniumFirefoxDriverInitAction
extends AbstractSeleniumDriverInitAction {
    private final String firefoxProfile;
    private final Map<String, String> firefoxPreferences;

    public SeleniumFirefoxDriverInitAction(FinallyActionRegistry finallyActionRegistry, Logger logger, @Input(value="hub") String hubUrl, @Input(value="headless") Boolean headless, @Input(value="driverPath") String driverPath, @Input(value="browserPath") String browserPath, @Input(value="firefoxProfile") String firefoxProfile, @Input(value="firefoxPreferences") Map<String, String> firefoxPreferences) {
        super(finallyActionRegistry, logger, hubUrl, headless, driverPath, browserPath);
        this.firefoxProfile = firefoxProfile;
        this.firefoxPreferences = Optional.ofNullable(firefoxPreferences).orElse(Collections.emptyMap());
    }

    @Override
    protected MutableCapabilities buildOptions() {
        FirefoxOptions firefoxOptions = new FirefoxOptions();
        firefoxOptions.addArguments(new String[]{"-headless"});
        firefoxOptions.setLogLevel(FirefoxDriverLogLevel.FATAL);
        try {
            FirefoxProfile profile = this.firefoxProfile != null ? FirefoxProfile.fromJson((String)this.firefoxProfile) : new FirefoxProfile();
            this.firefoxPreferences.forEach((arg_0, arg_1) -> ((FirefoxProfile)profile).setPreference(arg_0, arg_1));
            firefoxOptions.setProfile(profile);
        }
        catch (IOException e) {
            this.logger.error("Failed to read firefox profile" + e.getMessage());
        }
        return firefoxOptions;
    }

    @Override
    protected WebDriver localWebDriver(Capabilities capabilities) {
        System.setProperty("webdriver.gecko.driver", this.driverPath);
        FirefoxOptions firefoxOptions = new FirefoxOptions(capabilities);
        firefoxOptions.setBinary(this.browserPath);
        return new FirefoxDriver(firefoxOptions);
    }

    @Override
    protected Class<?> getChildClass() {
        return SeleniumFirefoxDriverInitAction.class;
    }
}

