/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.selenium.driver;

import com.chutneytesting.action.selenium.driver.AbstractSeleniumDriverInitAction;
import com.chutneytesting.action.spi.injectable.FinallyActionRegistry;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;

public class SeleniumChromeDriverInitAction
extends AbstractSeleniumDriverInitAction {
    private final List<String> chromeOptions;

    public SeleniumChromeDriverInitAction(FinallyActionRegistry finallyActionRegistry, Logger logger, @Input(value="hub") String hubUrl, @Input(value="headless") Boolean headless, @Input(value="driverPath") String driverPath, @Input(value="browserPath") String browserPath, @Input(value="chromeOptions") List<String> chromeOptions) {
        super(finallyActionRegistry, logger, hubUrl, headless, driverPath, browserPath);
        this.chromeOptions = Optional.ofNullable(chromeOptions).orElse(Collections.emptyList());
    }

    @Override
    protected MutableCapabilities buildOptions() {
        ChromeOptions options = new ChromeOptions();
        options.addArguments(new String[]{"start-maximized"});
        if (this.headless.booleanValue()) {
            options.addArguments(new String[]{"--headless"});
        }
        this.chromeOptions.forEach(xva$0 -> {
            ChromeOptions cfr_ignored_0 = (ChromeOptions)options.addArguments(new String[]{xva$0});
        });
        options.setCapability("goog:chromeOptions", (Object)options);
        return options;
    }

    @Override
    protected WebDriver localWebDriver(Capabilities capabilities) {
        System.setProperty("webdriver.chrome.driver", this.driverPath);
        ChromeOptions chromeOptions = new ChromeOptions().merge(capabilities);
        chromeOptions.setBinary(this.browserPath);
        return new ChromeDriver(chromeOptions);
    }

    @Override
    protected Class<?> getChildClass() {
        return SeleniumChromeDriverInitAction.class;
    }
}

