/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.selenium.driver;

import com.chutneytesting.action.spi.Action;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.FinallyAction;
import com.chutneytesting.action.spi.injectable.FinallyActionRegistry;
import com.chutneytesting.action.spi.injectable.Logger;
import com.chutneytesting.action.spi.validation.Validator;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;

public abstract class AbstractSeleniumDriverInitAction
implements Action {
    private final FinallyActionRegistry finallyActionRegistry;
    private final String hubUrl;
    protected final Logger logger;
    protected final Boolean headless;
    protected final String driverPath;
    protected final String browserPath;

    protected AbstractSeleniumDriverInitAction(FinallyActionRegistry finallyActionRegistry, Logger logger, String hubUrl, Boolean headless, String driverPath, String browserPath) {
        this.finallyActionRegistry = finallyActionRegistry;
        this.logger = logger;
        this.hubUrl = hubUrl;
        this.headless = headless;
        this.driverPath = driverPath;
        this.browserPath = browserPath;
    }

    protected abstract MutableCapabilities buildOptions();

    protected abstract WebDriver localWebDriver(Capabilities var1);

    protected abstract Class<?> getChildClass();

    public List<String> validateInputs() {
        Validator validate = Validator.of((Object)this.hubUrl).validate(hub -> StringUtils.isNotEmpty((CharSequence)hub) || StringUtils.isNotEmpty((CharSequence)this.browserPath) && StringUtils.isNotEmpty((CharSequence)this.driverPath), "Provide [hub] for selenium remote or [browserPath and driverPath] for selenium local");
        return Validator.getErrorsFrom((Validator[])new Validator[]{validate});
    }

    public ActionExecutionResult execute() {
        MutableCapabilities capabilities = this.buildOptions();
        WebDriver webDriver = this.createWebDriver((Capabilities)capabilities);
        this.configureWebDriver(webDriver);
        this.logger.info("RemoteWebDriver created : " + webDriver);
        this.createQuitFinallyAction(webDriver);
        return ActionExecutionResult.ok(this.toOutputs(webDriver));
    }

    WebDriver createWebDriver(Capabilities capabilities) {
        try {
            if (StringUtils.isNotEmpty((CharSequence)this.hubUrl)) {
                return new RemoteWebDriver(new URL(this.hubUrl), capabilities);
            }
            return this.localWebDriver(capabilities);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    private void createQuitFinallyAction(WebDriver webDriver) {
        this.finallyActionRegistry.registerFinallyAction(FinallyAction.Builder.forAction((String)"selenium-quit", this.getChildClass()).withInput("web-driver", (Object)webDriver).build());
        this.logger.info("Quit finally action registered");
    }

    private void configureWebDriver(WebDriver webDriver) {
        try {
            webDriver.manage().timeouts().implicitlyWait(Duration.of(0L, ChronoUnit.SECONDS));
        }
        catch (Exception e) {
            this.logger.error("Default configuration of the remote webDriver failed");
        }
    }

    private Map<String, Object> toOutputs(WebDriver webDriver) {
        HashMap<String, Object> outputs = new HashMap<String, Object>();
        outputs.put("webDriver", webDriver);
        return outputs;
    }
}

