/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.mongo;

import com.chutneytesting.action.mongo.DefaultMongoDatabaseFactory;
import com.chutneytesting.action.mongo.MongoActionValidatorsUtils;
import com.chutneytesting.action.mongo.MongoDatabaseFactory;
import com.chutneytesting.action.spi.Action;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import com.chutneytesting.action.spi.injectable.Target;
import com.chutneytesting.action.spi.validation.ActionValidatorsUtils;
import com.chutneytesting.action.spi.validation.Validator;
import com.chutneytesting.tools.CloseableResource;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoFindAction
implements Action {
    private final MongoDatabaseFactory mongoDatabaseFactory = new DefaultMongoDatabaseFactory();
    private final Target target;
    private final Logger logger;
    private final String collection;
    private final String query;
    private final Integer limit;

    public MongoFindAction(Target target, Logger logger, @Input(value="collection") String collection, @Input(value="query") String query, @Input(value="limit") Integer limit) {
        this.target = target;
        this.logger = logger;
        this.collection = collection;
        this.query = query;
        this.limit = Optional.ofNullable(limit).orElse(20);
    }

    public List<String> validateInputs() {
        return Validator.getErrorsFrom((Validator[])new Validator[]{ActionValidatorsUtils.notBlankStringValidation((String)this.collection, (String)"collection"), ActionValidatorsUtils.notBlankStringValidation((String)this.query, (String)"query"), MongoActionValidatorsUtils.mongoTargetValidation(this.target)});
    }

    public ActionExecutionResult execute() {
        ActionExecutionResult actionExecutionResult;
        block8: {
            CloseableResource<MongoDatabase> database = this.mongoDatabaseFactory.create(this.target);
            try {
                MongoIterable documents = ((MongoDatabase)database.getResource()).getCollection(this.collection).find((Bson)BsonDocument.parse((String)this.query)).limit(this.limit.intValue()).map(Document::toJson);
                ArrayList documentList = new ArrayList();
                documents.iterator().forEachRemaining(documentList::add);
                this.logger.info("Found " + documentList.size() + " document(s)");
                actionExecutionResult = ActionExecutionResult.ok(Collections.singletonMap("documents", documentList));
                if (database == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (database != null) {
                        try {
                            database.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalArgumentException e) {
                    this.logger.error(e.getMessage());
                    return ActionExecutionResult.ko();
                }
            }
            database.close();
        }
        return actionExecutionResult;
    }
}

