/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.mongo;

import com.chutneytesting.action.mongo.DefaultMongoDatabaseFactory;
import com.chutneytesting.action.mongo.MongoActionValidatorsUtils;
import com.chutneytesting.action.mongo.MongoDatabaseFactory;
import com.chutneytesting.action.spi.Action;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import com.chutneytesting.action.spi.injectable.Target;
import com.chutneytesting.action.spi.validation.ActionValidatorsUtils;
import com.chutneytesting.action.spi.validation.Validator;
import com.chutneytesting.tools.CloseableResource;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.result.DeleteResult;
import java.util.Collections;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;

public class MongoDeleteAction
implements Action {
    private final MongoDatabaseFactory mongoDatabaseFactory = new DefaultMongoDatabaseFactory();
    private final Target target;
    private final Logger logger;
    private final String collection;
    private final String query;

    public MongoDeleteAction(Target target, Logger logger, @Input(value="collection") String collection, @Input(value="query") String query) {
        this.target = target;
        this.logger = logger;
        this.collection = collection;
        this.query = query;
    }

    public List<String> validateInputs() {
        return Validator.getErrorsFrom((Validator[])new Validator[]{ActionValidatorsUtils.notBlankStringValidation((String)this.collection, (String)"collection"), ActionValidatorsUtils.notBlankStringValidation((String)this.query, (String)"query"), MongoActionValidatorsUtils.mongoTargetValidation(this.target)});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ActionExecutionResult execute() {
        try (CloseableResource<MongoDatabase> database = this.mongoDatabaseFactory.create(this.target);){
            DeleteResult deleteResult = ((MongoDatabase)database.getResource()).getCollection(this.collection).deleteMany((Bson)BsonDocument.parse((String)this.query));
            if (!deleteResult.wasAcknowledged()) {
                this.logger.error("Deletion was not acknowledged");
                ActionExecutionResult actionExecutionResult2 = ActionExecutionResult.ko();
                return actionExecutionResult2;
            }
            long deletedCount = deleteResult.getDeletedCount();
            this.logger.info("Deleted " + deletedCount + " document(s)");
            ActionExecutionResult actionExecutionResult = ActionExecutionResult.ok(Collections.singletonMap("deletedCount", deletedCount));
            return actionExecutionResult;
        }
        catch (IllegalArgumentException e) {
            this.logger.error(e.getMessage());
            return ActionExecutionResult.ko();
        }
    }
}

