/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.jakarta;

import com.chutneytesting.action.spi.Action;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.FinallyAction;
import com.chutneytesting.action.spi.injectable.FinallyActionRegistry;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;

public class JakartaBrokerStartAction
implements Action {
    private final Logger logger;
    private final FinallyActionRegistry finallyActionRegistry;
    private final String configurationUri;

    public JakartaBrokerStartAction(Logger logger, FinallyActionRegistry finallyActionRegistry, @Input(value="config-uri") String configUri) {
        this.logger = logger;
        this.finallyActionRegistry = finallyActionRegistry;
        this.configurationUri = Optional.ofNullable(configUri).orElseGet(this::defaultConfiguration);
    }

    public ActionExecutionResult execute() {
        try {
            ActiveMQServer brokerService = ActiveMQServers.newActiveMQServer((Configuration)new ConfigurationImpl().setPersistenceEnabled(false).setSecurityEnabled(false).addAcceptorConfiguration("broker", this.configurationUri));
            brokerService.start();
            this.logger.info("Started with configuration uri: " + this.configurationUri);
            this.createQuitFinallyAction(brokerService);
            return ActionExecutionResult.ok(this.toOutputs(brokerService));
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            return ActionExecutionResult.ko();
        }
    }

    private String defaultConfiguration() {
        return "tcp://localhost:61616";
    }

    private Map<String, Object> toOutputs(ActiveMQServer brokerService) {
        HashMap<String, Object> outputs = new HashMap<String, Object>();
        outputs.put("jmsBrokerService", brokerService);
        return outputs;
    }

    private void createQuitFinallyAction(ActiveMQServer brokerService) {
        this.finallyActionRegistry.registerFinallyAction(FinallyAction.Builder.forAction((String)"jakarta-broker-stop", JakartaBrokerStartAction.class).withInput("jakarta-broker-service", (Object)brokerService).build());
        this.logger.info("JmsBrokerStop finally action registered");
    }
}

