/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.selenium;

import com.chutneytesting.action.selenium.SeleniumAction;
import com.chutneytesting.action.selenium.SeleniumFindBehavior;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import java.util.Optional;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

public class SeleniumSendKeysAction
extends SeleniumAction
implements SeleniumFindBehavior {
    private final String value;
    private final String selector;
    private final String by;
    private final Integer wait;

    public SeleniumSendKeysAction(Logger logger, @Input(value="web-driver") WebDriver webDriver, @Input(value="selector") String selector, @Input(value="by") String by, @Input(value="wait") Integer wait, @Input(value="value") String value) {
        super(logger, webDriver);
        this.selector = selector;
        this.by = by;
        this.wait = wait;
        this.value = value;
    }

    @Override
    public ActionExecutionResult executeSeleniumAction() {
        if (this.value == null) {
            this.logger.error("No value given for sendKeys.");
            return ActionExecutionResult.ko();
        }
        Optional webElementOpt = this.findElement(this.logger, this.webDriver, this.selector, this.by, this.wait);
        if (webElementOpt.isPresent()) {
            WebElement webElement = (WebElement)webElementOpt.get();
            if ("select".equals(webElement.getTagName())) {
                new Select(webElement).selectByValue(this.value);
            } else {
                String[] values = this.value.split("\\*");
                Optional<Keys> key = this.mapKeysFromValue(values[0]);
                if (key.isPresent()) {
                    webElement.sendKeys(new CharSequence[]{key.get() + (values.length > 1 ? values[1] : "")});
                } else {
                    if ("input".equals(webElement.getTagName()) || "textaera".equals(webElement.getTagName())) {
                        try {
                            ((JavascriptExecutor)this.webDriver).executeScript("arguments[0].value = ''", new Object[]{webElement});
                        }
                        catch (Exception e) {
                            this.logger.info("JS clearing failed, try simple clearing");
                            try {
                                webElement.clear();
                            }
                            catch (ClassCastException cc) {
                                this.logger.error("WebDriver cannot execute simple clearing");
                                return ActionExecutionResult.ko();
                            }
                        }
                    }
                    webElement.sendKeys(new CharSequence[]{this.value});
                }
            }
            this.logger.info("Send keys to element : " + webElement);
            return ActionExecutionResult.ok();
        }
        this.takeScreenShot();
        this.logger.error("Cannot retrieve element to sendKeys to.");
        return ActionExecutionResult.ko();
    }

    private Optional<Keys> mapKeysFromValue(String value) {
        try {
            return Optional.of(Keys.valueOf((String)value));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Optional.empty();
        }
    }
}

