/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.selenium;

import com.chutneytesting.action.selenium.SeleniumDriverInitAction;
import com.chutneytesting.action.spi.Action;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.FinallyAction;
import com.chutneytesting.action.spi.injectable.FinallyActionRegistry;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxDriverLogLevel;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.remote.RemoteWebDriver;

public class SeleniumRemoteDriverInitAction
implements Action {
    private final FinallyActionRegistry finallyActionRegistry;
    private final Logger logger;
    private final String hubUrl;
    private final String browser;

    public SeleniumRemoteDriverInitAction(Logger logger, FinallyActionRegistry finallyActionRegistry, @Input(value="hub") String hubUrl, @Input(value="browser") String browser) {
        this.finallyActionRegistry = finallyActionRegistry;
        this.logger = logger;
        this.hubUrl = hubUrl;
        this.browser = browser;
    }

    public ActionExecutionResult execute() {
        WebDriver webDriver = switch (Optional.ofNullable(this.browser).orElse("")) {
            case "chrome" -> this.createChromeRemoteWebDriver();
            case "internet explorer" -> this.createInternetExplorerRemoteWebDriver();
            default -> this.createFirefoxRemoteWebDriver();
        };
        if (webDriver != null) {
            this.configureWebDriver(webDriver);
            this.logger.info("RemoteWebDriver created : " + webDriver);
            this.createQuitFinallyAction(webDriver);
            return ActionExecutionResult.ok(SeleniumDriverInitAction.toOutputs(webDriver));
        }
        this.logger.error("RemoteWebDriver creation failed.");
        return ActionExecutionResult.ko();
    }

    private void createQuitFinallyAction(WebDriver webDriver) {
        this.finallyActionRegistry.registerFinallyAction(FinallyAction.Builder.forAction((String)"selenium-quit", SeleniumRemoteDriverInitAction.class).withInput("web-driver", (Object)webDriver).build());
        this.logger.info("Quit finally action registered");
    }

    WebDriver createChromeRemoteWebDriver() {
        ChromeOptions chromeOptions = new ChromeOptions();
        chromeOptions.addArguments(new String[]{"start-maximized"});
        chromeOptions.setCapability("goog:chromeOptions", (Object)chromeOptions);
        return this.createRemoteWebDriver((Capabilities)chromeOptions);
    }

    WebDriver createInternetExplorerRemoteWebDriver() {
        return this.createRemoteWebDriver((Capabilities)SeleniumDriverInitAction.setIeOptions());
    }

    WebDriver createFirefoxRemoteWebDriver() {
        FirefoxOptions firefoxOptions = new FirefoxOptions();
        firefoxOptions.setHeadless(false);
        firefoxOptions.setLogLevel(FirefoxDriverLogLevel.FATAL);
        return this.createRemoteWebDriver((Capabilities)firefoxOptions);
    }

    private WebDriver createRemoteWebDriver(Capabilities capabilities) {
        try {
            return new RemoteWebDriver(new URL(this.hubUrl), capabilities);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    void configureWebDriver(WebDriver webDriver) {
        try {
            webDriver.manage().timeouts().implicitlyWait(Duration.of(0L, ChronoUnit.SECONDS));
        }
        catch (Exception e) {
            this.logger.error("Default configuration of the remote webDriver failed");
        }
    }
}

