/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.mongo;

import com.chutneytesting.action.mongo.DefaultMongoDatabaseFactory;
import com.chutneytesting.action.mongo.MongoActionValidatorsUtils;
import com.chutneytesting.action.mongo.MongoDatabaseFactory;
import com.chutneytesting.action.spi.Action;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Logger;
import com.chutneytesting.action.spi.injectable.Target;
import com.chutneytesting.action.spi.validation.Validator;
import com.chutneytesting.tools.CloseableResource;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MongoListAction
implements Action {
    private final MongoDatabaseFactory mongoDatabaseFactory = new DefaultMongoDatabaseFactory();
    private final Target target;
    private final Logger logger;

    public MongoListAction(Target target, Logger logger) {
        this.target = target;
        this.logger = logger;
    }

    public List<String> validateInputs() {
        return Validator.getErrorsFrom((Validator[])new Validator[]{MongoActionValidatorsUtils.mongoTargetValidation(this.target)});
    }

    public ActionExecutionResult execute() {
        ActionExecutionResult actionExecutionResult;
        block8: {
            CloseableResource<MongoDatabase> database = this.mongoDatabaseFactory.create(this.target);
            try {
                MongoIterable collectionNames = ((MongoDatabase)database.getResource()).listCollectionNames();
                ArrayList collectionNameList = new ArrayList();
                collectionNames.iterator().forEachRemaining(collectionNameList::add);
                this.logger.info("Found " + collectionNameList.size() + " collection(s)");
                actionExecutionResult = ActionExecutionResult.ok(Collections.singletonMap("collectionNames", collectionNameList));
                if (database == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (database != null) {
                        try {
                            database.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalArgumentException e) {
                    this.logger.error(e.getMessage());
                    return ActionExecutionResult.ko();
                }
            }
            database.close();
        }
        return actionExecutionResult;
    }
}

