/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.jms.consumer.bodySelector;

import com.chutneytesting.action.common.XmlUtils;
import com.chutneytesting.action.jms.consumer.bodySelector.BodySelector;
import com.chutneytesting.action.jms.consumer.bodySelector.BodySelectorParser;
import com.chutneytesting.action.jms.consumer.bodySelector.TextMessageBodySelector;
import com.chutneytesting.action.jms.domain.XmlContent;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom2.filter.Filters;
import org.jdom2.input.SAXBuilder;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;

class XpathBodySelectorParser
implements BodySelectorParser {
    private static final String BODY_SELECTOR_REGEX = "^XPATH '(?<xpath>.+)'$";
    private static final Pattern BODY_SELECTOR_PATTERN = Pattern.compile("^XPATH '(?<xpath>.+)'$");

    XpathBodySelectorParser() {
    }

    @Override
    public String description() {
        return "XPath selector: ^XPATH '(?<xpath>.+)'$";
    }

    @Override
    public Optional<BodySelector> tryParse(String selector) throws IllegalArgumentException {
        Optional<BodySelector> optionalBodySelector;
        Matcher matcher = BODY_SELECTOR_PATTERN.matcher(selector);
        if (matcher.matches()) {
            String xpath = matcher.group("xpath");
            XPathExpression xPathExpression = XPathFactory.instance().compile(xpath, Filters.fboolean());
            optionalBodySelector = Optional.of(new XpathBodySelector((XPathExpression<Boolean>)xPathExpression));
        } else {
            optionalBodySelector = Optional.empty();
        }
        return optionalBodySelector;
    }

    private static class XpathBodySelector
    extends TextMessageBodySelector {
        private final XPathExpression<Boolean> xPathExpression;
        private final SAXBuilder saxBuilder = XmlUtils.saxBuilder();

        XpathBodySelector(XPathExpression<Boolean> xPathExpression) {
            this.xPathExpression = xPathExpression;
        }

        @Override
        public boolean match(String messageBody) {
            XmlContent xmlContent = new XmlContent(this.saxBuilder, messageBody);
            return xmlContent.tryBuildDocumentWithoutNamespaces().map(arg_0 -> this.xPathExpression.evaluateFirst(arg_0)).orElse(Boolean.FALSE);
        }
    }
}

