/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.jms.consumer;

import com.chutneytesting.action.jms.consumer.Consumer;
import com.chutneytesting.action.jms.consumer.SelectedMessageConsumer;
import com.chutneytesting.action.jms.consumer.SimpleMessageConsumer;
import com.chutneytesting.action.jms.consumer.bodySelector.BodySelector;
import com.chutneytesting.action.jms.consumer.bodySelector.BodySelectorFactory;
import com.chutneytesting.action.spi.time.Duration;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;

public class ConsumerFactory {
    private final BodySelectorFactory bodySelectorFactory = new BodySelectorFactory();
    private final String bodySelector;
    private final String selector;
    private final String timeout;
    private final Integer browserMaxDepth;

    public ConsumerFactory(String bodySelector, String selector, String timeout, int browserMaxDepth) {
        this.bodySelector = bodySelector;
        this.selector = selector;
        this.timeout = timeout;
        this.browserMaxDepth = browserMaxDepth;
    }

    public Consumer build(Session session, Destination destination) throws JMSException {
        Consumer consumer;
        if (this.bodySelector == null || this.bodySelector.isEmpty()) {
            MessageConsumer messageConsumer = session.createConsumer(destination, this.selector);
            consumer = new SimpleMessageConsumer(messageConsumer, (int)Duration.parseToMs((String)this.timeout));
        } else {
            QueueBrowser browser = session.createBrowser((Queue)destination, this.selector);
            BodySelector bodySelectorBuild = this.bodySelectorFactory.build(this.bodySelector);
            consumer = new SelectedMessageConsumer(browser, bodySelectorBuild, this.browserMaxDepth);
        }
        return consumer;
    }
}

