/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.jakarta;

import com.chutneytesting.action.jakarta.JakartaConnectionFactory;
import com.chutneytesting.action.jakarta.UncheckedJakartaException;
import com.chutneytesting.action.jakarta.consumer.Consumer;
import com.chutneytesting.action.spi.Action;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import com.chutneytesting.action.spi.injectable.Target;
import com.chutneytesting.action.spi.validation.ActionValidatorsUtils;
import com.chutneytesting.action.spi.validation.Validator;
import com.chutneytesting.tools.CloseableResource;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.TextMessage;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class JakartaCleanQueueAction
implements Action {
    private final Target target;
    private final Logger logger;
    private final JakartaConnectionFactory jmsConnectionFactory = new JakartaConnectionFactory();
    private final String destination;
    private final String timeout;

    public JakartaCleanQueueAction(Target target, Logger logger, @Input(value="destination") String destination, @Input(value="timeout") String timeout) {
        this.target = target;
        this.logger = logger;
        this.destination = destination;
        this.timeout = (String)StringUtils.defaultIfEmpty((CharSequence)timeout, (CharSequence)"500 ms");
    }

    public List<String> validateInputs() {
        return Validator.getErrorsFrom((Validator[])new Validator[]{ActionValidatorsUtils.notBlankStringValidation((String)this.destination, (String)"destination"), ActionValidatorsUtils.durationValidation((String)this.timeout, (String)"timeout"), ActionValidatorsUtils.targetValidation((Target)this.target)});
    }

    public ActionExecutionResult execute() {
        ActionExecutionResult actionExecutionResult;
        block9: {
            CloseableResource<Consumer> consumer = this.jmsConnectionFactory.createConsumer(this.target, this.destination, this.timeout);
            try {
                Optional<Message> message;
                int removedMessages = 0;
                while ((message = ((Consumer)consumer.getResource()).getMessage()).isPresent()) {
                    this.displayMessageContent(this.logger, message.get());
                    ++removedMessages;
                }
                this.logger.info("Removed " + removedMessages + " messages");
                actionExecutionResult = ActionExecutionResult.ok();
                if (consumer == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (consumer != null) {
                        try {
                            consumer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (UncheckedJakartaException | JMSException e) {
                    this.logger.error(e);
                    return ActionExecutionResult.ko();
                }
            }
            consumer.close();
        }
        return actionExecutionResult;
    }

    private void displayMessageContent(Logger logger, Message message) throws JMSException {
        String body;
        Map<String, String> properties = this.propertiesToMap(message);
        if (message instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)message;
            body = textMessage.getText();
        } else {
            body = "";
        }
        logger.info("Removed: " + properties + " " + body);
    }

    private Map<String, String> propertiesToMap(Message message) throws JMSException {
        Enumeration propertyNames = message.getPropertyNames();
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        while (propertyNames.hasMoreElements()) {
            String propertyName = (String)propertyNames.nextElement();
            properties.put(propertyName, String.valueOf(message.getObjectProperty(propertyName)));
        }
        return properties;
    }
}

