/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.http.domain;

import com.chutneytesting.action.common.SecurityUtils;
import com.chutneytesting.action.http.domain.HttpClient;
import com.chutneytesting.action.spi.injectable.Logger;
import com.chutneytesting.action.spi.injectable.Target;
import java.net.MalformedURLException;
import java.net.ProxySelector;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.impl.routing.DefaultProxyRoutePlanner;
import org.apache.hc.client5.http.impl.routing.SystemDefaultRoutePlanner;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.SocketConfig;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class HttpClientFactory {
    private static final String PROXY_PROPERTY = "proxy";

    public HttpClient create(Logger logger, Target target, Class<String> responseType, int timeout) {
        RestTemplate restTemplate = HttpClientFactory.buildRestTemplate(logger, target, timeout);
        return (httpMethod, resource, input) -> restTemplate.exchange(target.uri().toString() + resource, httpMethod, input, responseType, new Object[0]);
    }

    private static RestTemplate buildRestTemplate(Logger logger, Target target, int timeout) {
        SSLContext sslContext;
        try {
            sslContext = SecurityUtils.buildSslContext(target).build();
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(timeout, TimeUnit.MILLISECONDS).build()).build();
        HttpClientBuilder httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager);
        Optional<HttpRoutePlanner> httpRoutePlanner = HttpClientFactory.getProxyConfiguration(logger, target);
        httpRoutePlanner.ifPresent(arg_0 -> ((HttpClientBuilder)httpClient).setRoutePlanner(arg_0));
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory((org.apache.hc.client5.http.classic.HttpClient)httpClient.build());
        requestFactory.setConnectTimeout(timeout);
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        HttpClientFactory.configureBasicAuth(target, restTemplate);
        HttpClientFactory.removeErrorHandler(restTemplate);
        return restTemplate;
    }

    private static Optional<HttpRoutePlanner> getProxyConfiguration(Logger logger, Target target) {
        if (HttpClientFactory.isTargetProxySet(target)) {
            try {
                String proxy = (String)target.property(PROXY_PROPERTY).orElseThrow();
                URL url = new URL(proxy);
                String host = url.getHost();
                String scheme = url.getProtocol();
                int port = Optional.ofNullable(url.getPort()).orElse(3128);
                HttpHost httpProxy = new HttpHost(scheme, host, port);
                logger.info("Proxy used: [" + httpProxy + "]");
                return Optional.of(new DefaultProxyRoutePlanner(httpProxy));
            }
            catch (MalformedURLException e) {
                logger.error("Malformed proxy url [" + (String)target.property(PROXY_PROPERTY).get() + "]" + e.getMessage());
                return Optional.empty();
            }
        }
        if (HttpClientFactory.isSystemProxySet().booleanValue()) {
            return Optional.of(new SystemDefaultRoutePlanner(ProxySelector.getDefault()));
        }
        return Optional.empty();
    }

    private static boolean isTargetProxySet(Target target) {
        return target.property(PROXY_PROPERTY).isPresent();
    }

    private static void removeErrorHandler(RestTemplate restTemplate) {
        restTemplate.setErrorHandler((ResponseErrorHandler)new NoOpResponseErrorHandler());
    }

    private static void configureBasicAuth(Target target, RestTemplate restTemplate) {
        if (target.user().isPresent()) {
            String user = (String)target.user().get();
            String password = target.userPassword().orElse("");
            restTemplate.getInterceptors().add(new BasicAuthenticationInterceptor(user, password, StandardCharsets.UTF_8));
        }
    }

    private static Boolean isSystemProxySet() {
        return Stream.of("http.proxyHost", "https.proxyHost").map(System::getProperty).anyMatch(Objects::nonNull);
    }

    private static class NoOpResponseErrorHandler
    extends DefaultResponseErrorHandler {
        private NoOpResponseErrorHandler() {
        }

        public void handleError(ClientHttpResponse response) {
        }
    }
}

