/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.selenium;

import com.chutneytesting.action.selenium.SeleniumAction;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import java.util.Set;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

public class SeleniumGetAction
extends SeleniumAction {
    private static final String SELENIUM_OUTPUTS_KEY = "outputGet";
    private final String selector;
    private final String value;

    public SeleniumGetAction(Logger logger, @Input(value="web-driver") WebDriver webDriver, @Input(value="selector") String selector, @Input(value="value") String value) {
        super(logger, webDriver);
        this.selector = selector;
        this.value = value;
    }

    @Override
    public ActionExecutionResult executeSeleniumAction() {
        if (this.selector != null) {
            Set<String> afterAllCurrentWindowHandles = this.getNewWindowHandle(this.webDriver);
            this.webDriver.switchTo().window((String)afterAllCurrentWindowHandles.toArray()[0]);
            this.logger.info("Switch to new window");
        }
        this.logger.info("Get url : " + this.value);
        this.webDriver.get(this.value);
        return ActionExecutionResult.ok((String)SELENIUM_OUTPUTS_KEY, (Object)this.webDriver.getWindowHandle());
    }

    private Set<String> getNewWindowHandle(WebDriver webDriver) {
        Set allCurrentWindowHandles = webDriver.getWindowHandles();
        ((JavascriptExecutor)webDriver).executeScript("window.open();", new Object[0]);
        Set afterAllCurrentWindowHandles = webDriver.getWindowHandles();
        afterAllCurrentWindowHandles.removeAll(allCurrentWindowHandles);
        return afterAllCurrentWindowHandles;
    }
}

