/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.ssh;

import com.chutneytesting.action.spi.Action;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import com.chutneytesting.action.spi.injectable.Target;
import com.chutneytesting.action.spi.time.Duration;
import com.chutneytesting.action.spi.validation.ActionValidatorsUtils;
import com.chutneytesting.action.spi.validation.Validator;
import com.chutneytesting.action.ssh.SshClientFactory;
import com.chutneytesting.action.ssh.sftp.ChutneySftpClient;
import com.chutneytesting.action.ssh.sftp.SftpClientImpl;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class SftpDownloadAction
implements Action {
    private final Target target;
    private final Logger logger;
    private final String source;
    private final String destination;
    private final String timeout;

    public SftpDownloadAction(Target target, Logger logger, @Input(value="source") String source, @Input(value="destination") String destination, @Input(value="timeout") String timeout) {
        this.target = target;
        this.logger = logger;
        this.source = source;
        this.destination = destination;
        this.timeout = (String)StringUtils.defaultIfEmpty((CharSequence)timeout, (CharSequence)SshClientFactory.DEFAULT_TIMEOUT);
    }

    public List<String> validateInputs() {
        return Validator.getErrorsFrom((Validator[])new Validator[]{ActionValidatorsUtils.notBlankStringValidation((String)this.source, (String)"source"), ActionValidatorsUtils.notBlankStringValidation((String)this.destination, (String)"destination"), ActionValidatorsUtils.durationValidation((String)this.timeout, (String)"timeout"), ActionValidatorsUtils.targetValidation((Target)this.target)});
    }

    public ActionExecutionResult execute() {
        ActionExecutionResult actionExecutionResult;
        block8: {
            ChutneySftpClient client = SftpClientImpl.buildFor(this.target, Duration.parseToMs((String)this.timeout), this.logger);
            try {
                client.download(this.source, this.destination);
                actionExecutionResult = ActionExecutionResult.ok();
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                    return ActionExecutionResult.ko();
                }
            }
            client.close();
        }
        return actionExecutionResult;
    }
}

