/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.ssh;

import com.chutneytesting.action.spi.Action;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import com.chutneytesting.action.spi.injectable.Target;
import com.chutneytesting.action.spi.validation.ActionValidatorsUtils;
import com.chutneytesting.action.spi.validation.Validator;
import com.chutneytesting.action.ssh.Connection;
import com.chutneytesting.action.ssh.sshj.CommandResult;
import com.chutneytesting.action.ssh.sshj.Commands;
import com.chutneytesting.action.ssh.sshj.SshJClient;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class SshClientAction
implements Action {
    private final Target target;
    private final Logger logger;
    private final List<Object> commands;
    private final String channel;

    public SshClientAction(Target target, Logger logger, @Input(value="commands") List<Object> commands, @Input(value="channel") String channel) {
        this.target = target;
        this.logger = logger;
        this.commands = commands;
        this.channel = Optional.ofNullable(channel).orElse(CHANNEL.COMMAND.name());
    }

    public List<String> validateInputs() {
        Validator commandsValidator = ActionValidatorsUtils.notEmptyListValidation(this.commands, (String)"commands").validate(Commands::from, noException -> true, "Syntax is a List of String or a List of {command: \"xxx\", timeout:\"10 s\"} Json");
        return Validator.getErrorsFrom((Validator[])new Validator[]{ActionValidatorsUtils.targetValidation((Target)this.target), commandsValidator});
    }

    public ActionExecutionResult execute() {
        try {
            Connection connection = Connection.from(this.target);
            boolean isSshChannel = CHANNEL.SHELL.equals((Object)CHANNEL.from(this.channel));
            SshJClient sshClient = new SshJClient(connection, isSshChannel, this.logger);
            List<CommandResult> commandResults = Commands.from(this.commands).executeWith(sshClient);
            HashMap<String, List<CommandResult>> actionResult = new HashMap<String, List<CommandResult>>();
            actionResult.put("results", commandResults);
            return ActionExecutionResult.ok(actionResult);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
            return ActionExecutionResult.ko();
        }
    }

    private static enum CHANNEL {
        COMMAND,
        SHELL;


        public static CHANNEL from(String channel) {
            for (CHANNEL value : CHANNEL.values()) {
                if (!value.name().equalsIgnoreCase(channel)) continue;
                return value;
            }
            return COMMAND;
        }
    }
}

