/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.radius;

import com.chutneytesting.action.radius.RadiusHelper;
import com.chutneytesting.action.spi.Action;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import com.chutneytesting.action.spi.injectable.Target;
import com.chutneytesting.action.spi.validation.ActionValidatorsUtils;
import com.chutneytesting.action.spi.validation.Validator;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.tinyradius.packet.AccountingRequest;
import org.tinyradius.packet.RadiusPacket;
import org.tinyradius.util.RadiusClient;
import org.tinyradius.util.RadiusException;

public class RadiusAccountingAction
implements Action {
    private final Logger logger;
    private final Target target;
    private final String userName;
    private final Map<String, String> attributes;
    private final Integer accountingType;

    public RadiusAccountingAction(Logger logger, Target target, @Input(value="userName") String userName, @Input(value="attributes") Map<String, String> attributes, @Input(value="accountingType") Integer accountingType) {
        this.logger = logger;
        this.target = target;
        this.userName = userName;
        this.accountingType = accountingType;
        this.attributes = Optional.ofNullable(attributes).orElse(Collections.emptyMap());
    }

    public List<String> validateInputs() {
        return Validator.getErrorsFrom((Validator[])new Validator[]{ActionValidatorsUtils.targetValidation((Target)this.target), RadiusHelper.radiusTargetPropertiesValidation(this.target), RadiusHelper.radiusTargetPortPropertiesValidation(this.target), ActionValidatorsUtils.notBlankStringValidation((String)this.userName, (String)"userName"), this.accountingTypeValidation()});
    }

    public ActionExecutionResult execute() {
        AccountingRequest accessRequest = new AccountingRequest(this.userName, this.accountingType.intValue());
        this.attributes.forEach((arg_0, arg_1) -> ((AccountingRequest)accessRequest).addAttribute(arg_0, arg_1));
        RadiusClient client = RadiusHelper.createRadiusClient(this.target);
        try {
            RadiusPacket response = client.account(accessRequest);
            if (response == null) {
                this.logger.error("Accounting failed. Response is null");
                return ActionExecutionResult.ko();
            }
            HashMap<String, RadiusPacket> outputs = new HashMap<String, RadiusPacket>();
            outputs.put("radiusResponse", response);
            this.logger.info("Accounting request as [" + this.userName + "] response type : " + response.getPacketTypeName());
            return ActionExecutionResult.ok(outputs);
        }
        catch (IOException | RadiusException e) {
            this.logger.error(e);
            return ActionExecutionResult.ko();
        }
    }

    private Validator<Integer> accountingTypeValidation() {
        return Validator.of((Object)this.accountingType).validate(at -> at >= 1 && at <= 15, "Invalid accountingType (by default start = 1, stop = 2, interim = 3, on = 7, off = 8)");
    }
}

