/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.jms.domain;

import com.google.common.base.Ascii;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlContent {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlContent.class);
    private static final String XML_DEFAULT_NAMESPACE_REGEX = "xmlns=\"[^\"]+\"";
    private static final Pattern XML_DEFAULT_NAMESPACE_PATTERN = Pattern.compile("xmlns=\"[^\"]+\"");
    private static final String XML_NAMESPACED_TAG_REGEX = "<(?<end>/?)([^:>\\s]+):(?<tag>[^>\\s]+)";
    private static final Pattern XML_NAMESPACED_TAG_PATTERN = Pattern.compile("<(?<end>/?)([^:>\\s]+):(?<tag>[^>\\s]+)");
    private final SAXBuilder saxBuilder;
    private final String stringRepresentationWithoutNamespaces;

    public XmlContent(SAXBuilder saxBuilder, String stringRepresentation) {
        this.saxBuilder = saxBuilder;
        Matcher matcher = XML_DEFAULT_NAMESPACE_PATTERN.matcher(stringRepresentation);
        String stringRepresentationWithoutDefaultNamespace = matcher.replaceAll("");
        this.stringRepresentationWithoutNamespaces = this.removeTagNamespaces(stringRepresentationWithoutDefaultNamespace);
    }

    public Optional<Document> tryBuildDocumentWithoutNamespaces() {
        Optional<Object> document;
        try {
            document = Optional.of(this.buildDocumentWithoutNamespaces());
        }
        catch (InvalidXmlDocumentException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            document = Optional.empty();
        }
        return document;
    }

    public Document buildDocumentWithoutNamespaces() throws InvalidXmlDocumentException {
        try {
            return this.saxBuilder.build((InputStream)new ByteArrayInputStream(this.stringRepresentationWithoutNamespaces.getBytes()));
        }
        catch (IOException | JDOMException e) {
            throw new InvalidXmlDocumentException(this.stringRepresentationWithoutNamespaces, (Exception)e);
        }
    }

    private String removeTagNamespaces(String stringRepresentationWithoutDefaultNamespace) {
        StringBuffer sb = new StringBuffer();
        Matcher matcher1 = XML_NAMESPACED_TAG_PATTERN.matcher(stringRepresentationWithoutDefaultNamespace);
        while (matcher1.find()) {
            String end = matcher1.group("end");
            String tag = matcher1.group("tag");
            matcher1.appendReplacement(sb, "<" + (end.isEmpty() ? "" : "/") + tag);
        }
        matcher1.appendTail(sb);
        return sb.toString();
    }

    public static class InvalidXmlDocumentException
    extends RuntimeException {
        InvalidXmlDocumentException(String documentAsString, Exception cause) {
            super("Unable to parse XML: " + Ascii.truncate((CharSequence)documentAsString, (int)100, (String)"..."), cause);
        }
    }
}

