/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.jms;

import com.chutneytesting.action.jms.UncheckedJmsException;
import com.chutneytesting.action.jms.consumer.Consumer;
import com.chutneytesting.action.jms.consumer.ConsumerFactory;
import com.chutneytesting.action.jms.consumer.JmsListenerParameters;
import com.chutneytesting.action.spi.injectable.Target;
import com.chutneytesting.tools.CloseableResource;
import com.chutneytesting.tools.ThrowingFunction;
import com.chutneytesting.tools.ThrowingSupplier;
import com.chutneytesting.tools.UncheckedException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Optional;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsConnectionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsConnectionFactory.class);

    public CloseableResource<Consumer> createConsumer(Target target, JmsListenerParameters arguments) {
        ConsumerFactory consumerFactory = new ConsumerFactory(arguments);
        return this.obtainCloseableResource(target, arguments.destination, consumerFactory::build);
    }

    public CloseableResource<MessageSender> getMessageProducer(Target target, String destinationName) throws UncheckedJmsException {
        return this.obtainCloseableResource(target, destinationName, (session, destination) -> {
            MessageProducer messageProducer = session.createProducer(destination);
            return (messageContent, headers) -> {
                TextMessage message = session.createTextMessage(messageContent);
                for (Map.Entry headerEntry : headers.entrySet()) {
                    message.setStringProperty((String)headerEntry.getKey(), (String)headerEntry.getValue());
                }
                messageProducer.send((Message)message);
            };
        });
    }

    private <T> CloseableResource<T> obtainCloseableResource(Target target, String destinationName, JmsThrowingBiFunction<Session, Destination, T> resourceBuilder) throws UncheckedJmsException {
        Hashtable<String, String> environmentProperties = new Hashtable<String, String>();
        environmentProperties.put("java.naming.provider.url", target.uri().toString());
        environmentProperties.putAll(target.prefixedProperties("java.naming."));
        environmentProperties.putAll(target.prefixedProperties("jndi.", true));
        this.configureSsl(target, environmentProperties);
        String connectionFactoryName = target.property("connectionFactoryName").orElse("ConnectionFactory");
        try {
            this.debugClassLoader();
            InitialContext context = new InitialContext(environmentProperties);
            ConnectionFactory connectionFactory = (ConnectionFactory)context.lookup(connectionFactoryName);
            Connection connection = this.createConnection(connectionFactory, target);
            connection.start();
            Session session = connection.createSession(false, 1);
            Destination destination = (Destination)context.lookup(destinationName);
            return CloseableResource.build(resourceBuilder.apply(session, destination), () -> {
                try {
                    session.close();
                }
                catch (JMSException e) {
                    LOGGER.warn("Unable to close JMS Session: " + e.getMessage());
                }
                try {
                    connection.close();
                }
                catch (JMSException e) {
                    LOGGER.warn("Unable to close JMS Connection: " + e.getMessage());
                }
            });
        }
        catch (InvalidSelectorException e) {
            throw new UncheckedJmsException("Cannot parse selector " + e.getMessage(), (Exception)((Object)e));
        }
        catch (NameNotFoundException e) {
            throw new UncheckedJmsException("Cannot find destination " + e.getMessage() + " on jms server " + target.name() + " (" + target.uri().toString() + ")", e);
        }
        catch (JMSException | NamingException e) {
            throw new UncheckedJmsException("Cannot connect to jms server " + target.name() + " (" + target.uri().toString() + "): " + e.getMessage(), (Exception)e);
        }
    }

    private void debugClassLoader() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        LOGGER.debug("Thread.currentThread().getContextClassLoader(): " + contextClassLoader);
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        LOGGER.debug("ClassLoader.getSystemClassLoader(): " + systemClassLoader);
    }

    private Connection createConnection(ConnectionFactory connectionFactory, Target target) throws JMSException {
        try {
            return (Connection)target.user().map(ThrowingFunction.toUnchecked(user -> connectionFactory.createConnection(user, target.userPassword().orElse("")))).orElseGet(ThrowingSupplier.toUnchecked(() -> ((ConnectionFactory)connectionFactory).createConnection()));
        }
        catch (UncheckedException e) {
            throw (JMSException)e.getCause();
        }
    }

    private void configureSsl(Target target, Map<String, String> environmentProperties) {
        this.putInMapIfPresent("connection.ConnectionFactory.keyStore", target.keyStore(), environmentProperties);
        this.putInMapIfPresent("connection.ConnectionFactory.keyStorePassword", target.keyStorePassword(), environmentProperties);
        this.putInMapIfPresent("connection.ConnectionFactory.keyStoreKeyPassword", target.keyPassword(), environmentProperties);
        this.putInMapIfPresent("connection.ConnectionFactory.trustStore", target.trustStore(), environmentProperties);
        this.putInMapIfPresent("connection.ConnectionFactory.trustStorePassword", target.trustStorePassword(), environmentProperties);
    }

    private void putInMapIfPresent(String key, Optional<String> optionalValue, Map<String, String> map) {
        optionalValue.ifPresent(s -> map.put(key, (String)s));
    }

    public static interface MessageSender {
        public void send(String var1, Map<String, String> var2) throws JMSException;
    }

    private static interface JmsThrowingBiFunction<T1, T2, R> {
        public R apply(T1 var1, T2 var2) throws JMSException;
    }
}

