/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.jms;

import com.chutneytesting.action.spi.Action;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import com.chutneytesting.action.spi.validation.Validator;
import java.util.List;
import java.util.Objects;
import org.apache.activemq.broker.BrokerService;

public class JmsBrokerStopAction
implements Action {
    private final Logger logger;
    private final BrokerService brokerService;

    public JmsBrokerStopAction(Logger logger, @Input(value="jms-broker-service") BrokerService brokerService) {
        this.logger = logger;
        this.brokerService = brokerService;
    }

    public List<String> validateInputs() {
        Validator jmsBrokerValidation = Validator.of((Object)this.brokerService).validate(Objects::nonNull, "No jms-broker-service provided");
        return Validator.getErrorsFrom((Validator[])new Validator[]{jmsBrokerValidation});
    }

    public ActionExecutionResult execute() {
        this.logger.info("Call jms broker shutdown");
        try {
            this.brokerService.stop();
            return ActionExecutionResult.ok();
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            return ActionExecutionResult.ko();
        }
    }
}

