/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.function;

import com.chutneytesting.action.spi.SpelFunction;
import com.chutneytesting.tools.SocketUtils;
import com.chutneytesting.tools.ThrowingFunction;
import com.chutneytesting.tools.ThrowingPredicate;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Collections;
import java.util.Random;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class NetworkFunctions {
    @SpelFunction
    public static int tcpPort() {
        return SocketUtils.findAvailableTcpPort();
    }

    @SpelFunction
    public static SortedSet<Integer> tcpPorts(int num) {
        return SocketUtils.findAvailableTcpPorts((int)num);
    }

    @SpelFunction
    public static int tcpPortMin(int minPort) {
        return SocketUtils.findAvailableTcpPort((int)minPort);
    }

    @SpelFunction
    public static int tcpPortMinMax(int minPort, int maxPort) {
        return SocketUtils.findAvailableTcpPort((int)minPort, (int)maxPort);
    }

    @SpelFunction
    public static SortedSet<Integer> tcpPortsMinMax(int num, int minPort, int maxPort) {
        return SocketUtils.findAvailableTcpPorts((int)num, (int)minPort, (int)maxPort);
    }

    @SpelFunction
    public static int tcpPortRandomRange(int range) {
        Integer[] httpPortRange = NetworkFunctions.getRandomPortRange(range);
        return SocketUtils.findAvailableTcpPort((int)httpPortRange[0], (int)httpPortRange[1]);
    }

    @SpelFunction
    public static SortedSet<Integer> tcpPortsRandomRange(int num, int range) {
        Integer[] httpPortRange = NetworkFunctions.getRandomPortRange(range);
        return SocketUtils.findAvailableTcpPorts((int)num, (int)httpPortRange[0], (int)httpPortRange[1]);
    }

    @SpelFunction
    public static int udpPort() {
        return SocketUtils.findAvailableUdpPort();
    }

    @SpelFunction
    public static SortedSet<Integer> udpPorts(int num) {
        return SocketUtils.findAvailableUdpPorts((int)num);
    }

    @SpelFunction
    public static int udpPortMin(int minPort) {
        return SocketUtils.findAvailableUdpPort((int)minPort);
    }

    @SpelFunction
    public static int udpPortMinMax(int minPort, int maxPort) {
        return SocketUtils.findAvailableUdpPort((int)minPort, (int)maxPort);
    }

    @SpelFunction
    public static SortedSet<Integer> udpPortsMinMax(int num, int minPort, int maxPort) {
        return SocketUtils.findAvailableUdpPorts((int)num, (int)minPort, (int)maxPort);
    }

    @SpelFunction
    public static int udpPortRandomRange(int range) {
        Integer[] httpPortRange = NetworkFunctions.getRandomPortRange(range);
        return SocketUtils.findAvailableUdpPort((int)httpPortRange[0], (int)httpPortRange[1]);
    }

    @SpelFunction
    public static SortedSet<Integer> udpPortsRandomRange(int num, int range) {
        Integer[] httpPortRange = NetworkFunctions.getRandomPortRange(range);
        return SocketUtils.findAvailableUdpPorts((int)num, (int)httpPortRange[0], (int)httpPortRange[1]);
    }

    @SpelFunction
    public static String randomNetworkMask() {
        StringBuilder networkMaskBuilder = new StringBuilder();
        networkMaskBuilder.append(System.nanoTime() * new Random().nextLong());
        networkMaskBuilder.reverse();
        networkMaskBuilder.delete(9, networkMaskBuilder.length());
        networkMaskBuilder.insert(6, '.').insert(3, '.');
        StringTokenizer stringTokenizer = new StringTokenizer(networkMaskBuilder.toString(), ".");
        networkMaskBuilder = new StringBuilder();
        while (stringTokenizer.hasMoreTokens()) {
            networkMaskBuilder.append(Integer.valueOf(stringTokenizer.nextToken()) % 255);
            networkMaskBuilder.append(".");
        }
        networkMaskBuilder.deleteCharAt(networkMaskBuilder.length() - 1);
        return networkMaskBuilder.toString();
    }

    @SpelFunction
    public static String hostIpMatching(String regex) throws Exception {
        return Collections.list(NetworkInterface.getNetworkInterfaces()).stream().filter(ThrowingPredicate.toUnchecked(NetworkInterface::isUp)).map(ThrowingFunction.toUnchecked(NetworkInterface::getInetAddresses)).flatMap(addresses -> Collections.list(addresses).stream()).flatMap(address -> Stream.of(address.getCanonicalHostName(), address.getHostAddress())).distinct().filter(ip -> NetworkFunctions.matches(regex, ip)).findFirst().orElse(InetAddress.getLocalHost().getHostAddress());
    }

    @SpelFunction
    public static String hostIpReaching(String remoteHost) throws Exception {
        int remotePort = 8888;
        try (DatagramSocket socket = new DatagramSocket();){
            socket.connect(InetAddress.getByName(remoteHost), 8888);
            String string = socket.getLocalAddress().getHostAddress();
            return string;
        }
    }

    private static Boolean matches(String regex, String text) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        return matcher.matches();
    }

    private static Integer[] getRandomPortRange(int maxRangesNumber) {
        int range = 64511 / maxRangesNumber;
        int rangeMin = 1024 + new Random().nextInt(maxRangesNumber) * range;
        return new Integer[]{rangeMin, rangeMin + range};
    }
}

